import asyncio

class AsyncIter:
    def __init__(self, iterable):
        self.iter_ = iter(iterable)
 
    async def __aiter__(self):
        return self
 
    async def __anext__(self):
        await asyncio.sleep(0)
        try:
            object = next(self.iter_)
        except StopIteration:
            raise StopAsyncIteration
 
        return object

async def amain(text):
    async for char in AsyncIter(text):
        print(char)


text = 'Hello world!'
##loop = asyncio.get_event_loop()
##loop.run_until_complete(amain(text))

co = amain(text)
while True:
    try:
        co.send(None)
    except StopIteration:
        break
