### test file for coroutines
### code using asend, athrow, etc.

import asyncio

async def agen1():
    x = yield "Hello,"
    try:
        while True:
            await asyncio.sleep(0.1)
            x = yield x
    except StopAsyncIteration:
        await asyncio.sleep(0.1)
        yield 'Bye!'

async def coro():
    ag = agen1()
    for s in None, "Alice,", "Bob,", "Charlie!":
        v = await ag.asend(s)
        print(v, end=" ")
        
    v = await ag.athrow(StopAsyncIteration)
    print("\n" + v)
    
    return v

loop = asyncio.get_event_loop()
x = loop.run_until_complete(coro())
print(x)



