# 文件 ABC_shapes.py
# 本模块定义几个几何形状类
# 主要展示用抽象公共基类（ABC）实现基于接口的编程
# 修改原定义，首先定义一个公共基类 Shape
# 与前面不同，这里利用标准库 abc.py 包里的 ABC 类继承

##from abc import ABC, abstractmethod
##
##class Shape(ABC):
##    @abstractmethod
##    def area(self): pass
##
##    @abstractmethod
##    def move(self, delta_x, delta_y): pass
##
##    def name(self): return "Shape"
##
##    def show(self):
##        print("I am a", self.name() +".",
##              "My area is", self.area())

from abc import ABCMeta, abstractmethod

class Shape(metaclass=ABCMeta):
    @abstractmethod
    def area(self): pass

    @abstractmethod
    def move(self, delta_x, delta_y): pass

    def name(self): return "Shape"

    def show(self):
        print("I am a", self.name() +".",
              "My area is", self.area())

class Uncompleted(Shape):
    def __init__(self): self.a = 1
    def area(self): return 1
    
class Point(Shape):
    def __init__(self, x, y):
        self._x = x
        self._y = y

    def getx(self):
        return self._x

    def gety(self):
        return self._y

    def area(self):
        return 0

    def move(self, delta_x, delta_y):
        self._x += delta_x
        self._y += delta_y

    def name(self): return "Point"

class Rectangle(Shape):
    def __init__(self, point, length, width):
        self._point = point
        self._length = length
        self._width = width

    def getx(self):
        return self._point.getx()
    
    def gety(self):
        return self._point.gety()

    def area(self):
        return self._length * self._width

    def move(self, delta_x, delta_y):
        self._point.move(delta_x, delta_y)

    def name(self): return "Rectangle"


def area(slist):
    s = 0
    for x in slist:
        if isinstance(x, Shape):
            s += x.area()
    return s

if __name__ == "__main__":
    x = Point(2, 3)
    y = Rectangle(x, 3, 5)
    z = Rectangle(x, 6, 8)

    x.show()
    y.show()

    print("Total Area:", area([x, y, z]))   

