#### Python语言手册上有关metaclass的实例
#### 所定义类里的数据属性members记录着属性定义的顺序

import collections
        
class OrderedClass(type):

     @classmethod
     def __prepare__(metacls, name, bases, **kwds):
        return collections.OrderedDict()

     def __new__(cls, name, bases, namespace, **kwds):
        result = type.__new__(cls, name, bases, dict(namespace))
        result.members = tuple(namespace)
        
        return result

class A(metaclass=OrderedClass):
    zero = 0
    def one(self): pass
    def two(self): pass
    three = 3
    def four(self): pass

print(A.members)
#('__module__', '__qualname__', 'zero', 'one', 'two', 'three', 'four')
