# 文件crlist.py
# 基于已定义的Countable类和RotatableList类，
# 定义了一个包含左右循环移位和计数的表类

from countable import Countable
from rotatablelist import RotatableList

class CRList(Countable, RotatableList):
    def __init__(self, *args):
        Countable.__init__(self)
        RotatableList.__init__(self, *args)
    

if __name__ == "__main__":
    ls1 = CRList([1, 2, 3, 4, 5, 6, 7, 8, 9, 0])
    ls2 = CRList("Hello, countable and rotable list!")

    ls2.rot_left(3)
    print(ls2[:10])
    ls1.rot_right(7)
    print(ls1[:5])

    print(CRList.get_count())
