# Read a file and obtain its word statistics

def word_stat(infname, stat_file):
    word_dict = {}
    num = 0
    textfile = open(infname)

    for line in textfile:
        word_list = line.split()
        for word in word_list:
            word = word.strip(",.:';!?()-_$/`~\"\\")
            if word == "":
                continue
            word_dict[word] = word_dict.get(word, 0) + 1
            num += 1
    textfile.close()

    outfile = open(stat_file, "w")
    for word in sorted(word_dict.keys()):
        outfile.write(word + ", " + str(word_dict[word]) + "\n")
    outfile.close()
    return num, len(word_dict)

if __name__ == "__main__":
    total, diff = word_stat("sun1.txt", "stat_result.txt")
    print("Total words:", total)
    print("Different words:", diff)
