#### 采用马尔可夫链技术生成随机文本

## 字典 word_dict，关键码为 (w1, w2)，值为单词对 w1, w2 后继的表，可能重复
## 函数 build_dict 读入文件建立字典 word_dict
## 函数 generate 基于 word_dict 和原文中最前的两个单词 word1, word2
## 生成一段正文

from random import choice, seed

def build_dict(infile):
    prefix = (" ", " ")
    word_dict = {}
    
    for line in infile:
        for word in line.split():
            if prefix in word_dict:
                word_dict[prefix].append(word)
            else:
                word_dict[prefix] = [word]
            prefix = (prefix[1], word)

    infile.close()
    return word_dict

def generate(outfile, word_dict, length):
    prefix = (" ", " ")
    seed()

    for i in range(length):
        if prefix in word_dict:
            wlist = word_dict.get(prefix)
            word = choice(wlist)
            outfile.write(word)
            prefix = (prefix[1], word)
            if i != length - 1:
                outfile.write(" ")
            else:
                return
        else:
            return

# Main program
if __name__ == "__main__":
    from sys import stdout
    
    inf_name = input("Please give a file name: ")
    infile = open(inf_name)
    word_dict = build_dict(infile)
    generate(stdout, word_dict, 100)
