# 计算立方根的程序

def cbrt(x):
    def not_enough():
        return abs(guess**3 - x) > 1e-6

    def improve():
        return (2.0 * guess + x / guess / guess) / 3

    if x == 0.0:
        return 0.0

    guess = x
    while not_enough():
        guess = improve()
    return guess

for x in 1, 2, 4, 8, 16, 32, 64:
    print("Cube root of", x, "is", cbrt(x))




