dyn.load(paste("ahfun", .Platform$dynlib.ext, sep=""))
source("ahfun.R")

# generate test data
require(MASS)
set.seed(21)
n <- 200; p <- 50
sig <- matrix(, p, p)
sig <- 0.5^abs(row(sig) - col(sig))
z <- mvrnorm(2*n, rep(0, p), sig)

bet <- c(rep(c(1, 0, -1, 0, 0), 3), rep(0, p - 15))		# true beta
haz <- drop(1 + z %*% bet)
ind <- (1:length(haz))[haz > 0][1:n]
z <- z[ind, ]			# covariate
haz <- haz[ind]

ft <- rexp(n, haz)
ct <- runif(n, 0, 3)
cft <- pmin(ft, ct)		# censored failure time
del <- ft <= ct			# failure status

# solve by coordiante descent
ans <- cd(cft, del, z, "SICA")
sol <- ans$sol; lam <- ans$lam

# cross-validate
ans <- cv(cft, del, z, "SICA", lam)
i <- ans$i; j <- ans$j
bet.hat <- sol[, i, j]
