### Generate data (for example, p = 50) ###
p <- 50
Runs <- 100
n <- 100
source("SimuGener.r")
Simu_data(p,n,Runs)

### Analyze simulated data (for example, simu_50_1.RData) ###
### the LNM model ###
source("LNM.r")
p <- 50
test <- 1
current_file <- sprintf("simu_%d_%d.RData",p,test)
load(current_file)
result_file1 <- sprintf("analysisLNM_%d_%d.RData",p,test)
lnm <- LNM(base, simu_x)
LNM_mu <- lnm$LNM_mu
LNM_sigma <- lnm$LNM_sigma
LNM_y <- lnm$LNM_y
save(simu_x, base, LNM_mu, LNM_sigma, LNM_y, file = result_file1)
prop.lnm <- Prediction.LNM(p, test)

### the LNM+ model ###
source("LNMplus.r")
p <- 50
test <- 1
current_file <- sprintf("simu_%d_%d.RData",p,test)
load(current_file)
system("mkdir temp")
require("foreach")
require("doParallel")
cl <- makeCluster(50, outfile = "")
registerDoParallel(cl)
Runs <- 100
D <- 5
Lk <- 10
mylist <- CVlist(Runs, D, Lk)
testlist <- mylist[mylist[,1]==test,]
myre <- foreach(i = 1:nrow(testlist), .packages = c('MASS')) %dopar% {
  CV.PAR(p, testlist[i,])
}
stopCluster(cl)
result_file2 <- sprintf("analysisLNMp_%d_%d.RData",p,test)
lnmp <- LNMp.CV(p,test)
LNMp_nu <- lnmp$LNMp_nu
LNMp_D <- lnmp$LNMp_D
LNMp_z <- lnmp$LNMp_z
LNMp_mu <- lnmp$LNMp_mu
LNMp_sigma <- lnmp$LNMp_sigma
save(simu_x, base, LNMp_nu, LNMp_D, LNMp_z, LNMp_mu, LNMp_sigma, file = result_file2)
prop.lnmp <- Prediction.LNMp(p, test)
