###### LNM+ ######
require("MASS") # required by mvrnorm
LNMp <- function(base, x, kappa, Iter1 = 5e3, samplenum = 5, HMC_burn = 1){
  r0 <- 1
  a <- 0.65

  ### Initialize all the parameters ###
  N <- nrow(x)
  p <- ncol(x)
  if (base != p){
    x <- x[,c(1:(base-1),(base+1):p,base)]
  }
  h1 <- (sqrt(p)-1)/(p-1) # H.half = I + h1*1*1^T
  h2 <- (1-sqrt(p))/(p-1)/sqrt(p) # H.half.inv = I + h2*1*1^T
  I <- diag(p-1)
  J <- matrix(1,p-1,p-1)
  M <- rowSums(x)
  tx <- x
  tx[tx==0] <- 0.05
  y <- log(tx[,1:p-1]/tx[,p])
  mu <- colMeans(y)
  mu <- mu + h2*sum(mu)
  tt <- 5
  sigma <- cov(y) + tt*diag(p-1)
  sigma <- (I + h2*J)%*%sigma%*%(I + h2*J)
  T1 <- mu
  T2 <- sigma + T1%*%t(T1)
  y <- y + h2*repmat(rowSums(y),1,p-1)
  Iter2 <- samplenum + 1
  R <- Iter2 - HMC_burn

  for (em in 1:Iter1){
    r <- r0/((em+1)^a)
    y_store <- HMCsampling.cond(mu, sigma, y, x, Iter2)
    y <- y_store[,,Iter2] ### transfer the last sample to the next EM iteration
    ny_store <- y_store[,,(HMC_burn+1):Iter2]
    ny_store <- apply(ny_store,2,rbind)
    T1_add <- colSums(ny_store)/N/R
    T2_add <- t(ny_store)%*%ny_store/N/R
    T1 <- (1-r)*T1 + r*T1_add
    T2 <- (1-r)*T2 + r*T2_add
    sigma_0 <- sigma
    sigma <- T2 - T1%*%t(T1)
    sigma <- Regcond(sigma,kappa)
    dsigma <- norm(sigma_0-sigma,"f")
    mu_0 <- mu
    mu <- T1
    dmu <- norm.vec.2(mu_0-mu)

    stoprule1 <- dmu/norm.vec.2(mu_0)
    stoprule2 <- dsigma/norm(sigma_0,"f")
    if (stoprule1<7.5e-5 & stoprule2<1.5e-3){
      break
    }
  }

  return(list(LNMp_nu = mu, LNMp_D = sigma, LNMp_z = y, LNMp_mu = mu+h1*sum(mu), LNMp_sigma = (I+h1*J)%*%sigma%*%(I+h1*J), LNMp_step = em))
}

LNMp.CV <- function(p, test, Iter1 = 5e3, samplenum = 5, HMC_burn = 1){
  Runs <- 100
  D <- 5
  Lk <- 10
  logk <- seq(1.5,4.2,0.3)
  kappa <- exp(logk)
  Cvalue <- matrix(0,Lk,D)
  mylist <- CVlist(Runs,D,Lk)
  nowlist <- mylist[mylist[,1]==test,]

  current_file <- sprintf("simu_%d_%d.RData",p,test)
  load(current_file) # simu_x, base
  for (i in 1:nrow(nowlist)) {
    d <- nowlist[i,2]
    k <- nowlist[i,3]
    open_file <- sprintf("temp/temp_%d_%d_%d.RData",test,d,k)
    load(open_file) # nu, matD
    N <- nrow(simu_x)
    tn <- simu_x[((d-1)*N/D+1):(d*N/D),]
    Cvalue[k,d] <- loglikeli(tn,nu,matD)
  }
  id_kappa <- which.max(rowSums(Cvalue))
  temp <- LNMp(base,simu_x,kappa[id_kappa],Iter1,samplenum,HMC_burn)
  LNMp_nu <- temp$LNMp_nu
  LNMp_D <- temp$LNMp_D
  LNMp_z <- temp$LNMp_z
  LNMp_mu <- temp$LNMp_mu
  LNMp_sigma <- temp$LNMp_sigma
  LNMp_step <- temp$LNMp_step

  return(list(LNMp_nu = LNMp_nu, LNMp_D = LNMp_D, LNMp_z = LNMp_z, LNMp_mu = LNMp_mu, LNMp_sigma = LNMp_sigma, LNMp_step = LNMp_step))
}

Prediction.LNMp <- function(p, test, samplenum = 1e3, gap = 2e1, HMC_burn = 5e2) {
  current_file <- sprintf("analysisLNMp_%d_%d.RData",p,test)
  load(current_file) # simu_x, base, LNMp_nu, LNMp_D, LNMp_z
  Iter <- samplenum*gap + HMC_burn
  x <- simu_x
  N <- nrow(x)
  p <- ncol(x)
  h1 <- (sqrt(p)-1)/(p-1) # H.half = I + h1*1*1^T
  mu <- LNMp_nu
  sigma <- LNMp_D
  y <- LNMp_z
  y_store <- HMCsampling.cond(mu, sigma, y, x, Iter)
  id <- seq(HMC_burn+1,Iter,gap)
  LNMp_pi <- matrix(0,N,p)
  prenum <- length(id)
  for (i in 1:prenum) {
    id_y <- id[i]
    ty <- y_store[,,id_y]+h1*repmat(rowSums(y_store[,,id_y]),1,p-1)
    ncondy <- cbind(ty,rep(0,N))
    LNMp_pi <- LNMp_pi + exp(ncondy)/repmat(rowSums(exp(ncondy)),1,p)
  }
  LNMp_pi <- LNMp_pi/prenum

  if (base != p){
    LNMp_pi <- LNMp_pi[,c(1:(base-1),p,base:(p-1))]
  }

  return(LNMp_pi)
}

### basic function
norm.vec.2 <- function(x) sqrt(sum(x^2))

repmat <- function(Mat, m1, n1) {
  Mat <- as.matrix(Mat)
  s1 <- rep(1:nrow(Mat),m1)
  t1 <- rep(1:ncol(Mat),n1)
  newMat <- as.matrix(Mat[s1,])
  newMat <- as.matrix(newMat[,t1])
  return(newMat)
}

cond <- function(x){
  d <- svd(x)$d
  return(max(d)/min(d))
}

Accept_hmc.cond <- function(x, M, ay, ap, by, bp, nu, D, h1){
  N <- nrow(x)
  p <- ncol(x)
  tempx <- x[,-p]
  hay <- ay + h1*repmat(rowSums(ay),1,p-1)
  hby <- by + h1*repmat(rowSums(by),1,p-1)
  log_pt1 <- rowSums(tempx*(hay - hby))
  log_pt2 <- rowSums(-0.5*(ay*t(solve(D,t(ay) - 2*repmat(nu,1,N))) - by*t(solve(D,t(by) - 2*repmat(nu,1,N)))))
  log_pt3 <- M*log((1 + rowSums(exp(hby)))/(1 + rowSums(exp(hay))))
  log_pt4 <- 0.5*rowSums((bp - ap)%*%D*(bp + ap))

  accept <- pmin.int(1,exp(log_pt1 + log_pt2 + log_pt3 + log_pt4))

  return(accept)
}

Regcond <- function(S, kappa){
  p <- ncol(S) + 1
  S <- (S+t(S))/2

  if (cond(S) <= kappa){
    sigma <- S
  } else {
    ss <- svd(S)
    lam <- ss$d
    Q <- ss$u

    a <- p - 1
    b <- which(kappa*lam[a]>=lam)[1] - 1

    while (a>=2 & b>=1) {
      tau <- (sum(lam[1:b])/kappa + sum(lam[a:(p-1)]))/(b+p-a)
      if (tau>lam[a] & tau<=lam[a-1] & (kappa*tau)>=lam[b+1] & (kappa*tau)<lam[b]) {
        break
      } else{
        if (lam[b]>(kappa*lam[a-1])){
          a <- a - 1
        } else{
          b <- b - 1
        }
      }
    }

    lambda <- pmin.int(pmax.int(tau,lam),kappa*tau)
    sigma <- Q%*%diag(lambda)%*%t(Q)
  }

  return(sigma)
}

CVlist <- function(Runs, D, Lk) {
  c1 <- rep(1:Lk,Runs*D)
  temp <- as.vector(t(repmat(1:D,1,Lk)))
  c2 <- rep(temp,Runs)
  c3 <- as.vector(t(repmat(1:Runs,1,D*Lk)))
  mylist <- cbind(c3,c2,c1)
  colnames(mylist) <- NULL

  return(mylist)
}

CV.PAR <- function(p, testlisti, Iter1 = 5e3, samplenum = 5, HMC_burn = 1){
  test <- testlisti[1]
  d <- testlisti[2]
  k <- testlisti[3]
  current_file <- sprintf("simu_%d_%d.RData",p,test)
  load(current_file)

  D <- 5
  logk <- seq(1.5,4.2,0.3)
  kappa <- exp(logk)

  N <- nrow(simu_x)
  x <- simu_x[-(((d-1)*N/D+1):(d*N/D)),]
  temp <- LNMp(base,x,kappa[k],Iter1,samplenum,HMC_burn)
  nu <- temp$LNMp_nu
  matD <- temp$LNMp_D

  save_file <- sprintf("temp/temp_%d_%d_%d.RData",test,d,k)
  save(nu, matD, file=save_file)
}

require("Rmpfr") # required by mpfr
loglikeli <- function(x, nu, D) {
  Q <- 1e3
  N <- nrow(x)
  p <- ncol(x)
  h1 <- (sqrt(p)-1)/(p-1) # H.half = I + h1*1*1^T
  D <- (D+t(D))/2
  value <- 0

  for (i in 1:N) {
    sample_yi <- mvrnorm(Q,nu,D)
    x_i <- x[i,-p]
    hsample_yi <- sample_yi + h1*repmat(rowSums(sample_yi),1,p-1)
    t_i <- rowSums(hsample_yi*t(repmat(x_i,1,Q))) - sum(x[i,])*log(1+rowSums(exp(hsample_yi))) # Q vector
    meant_i <- mean(t_i)
    value <- value+log(mean(exp(mpfr(t_i-meant_i,60))))+meant_i
  }
  return(as.numeric(value))
}

HMCsampling.cond <- function(mu, sigma, y, x, Iter){
  N <- nrow(x)
  p <- ncol(x) 
  M <- rowSums(x)
  D0 <- 6:15
  d0 <- seq(5.5e-2,6.5e-2,1e-3)
  LD <- length(D0)
  Ld <- length(d0)
  y_store <- array(0,dim=c(N,p-1,Iter))
  y_store[,,1] <- y
  h1 <- (sqrt(p)-1)/(p-1) # H.half = I + h1*1*1^T
  hx <- x[,-p]+h1*repmat(rowSums(x[,-p]),1,p-1)
  for (mc in 1:(Iter-1)){ ### HMC
    rd <- sample(1:Ld,1)
    d <- d0[rd]
    rD <- sample(1:LD,1)
    D <- D0[rD]
    by <- y_store[,,mc]
    bp <- mvrnorm(N,rep(0,p-1),solve(sigma))
    ap <- bp
    ay <- by
    hay <- ay + h1*repmat(rowSums(ay),1,p-1)
    ap <- ap - d/2*(-hx + repmat(M/(1 + rowSums(exp(hay))),1,(p-1))*(exp(hay) - h1*matrix(1,N,p-1)) + h1*repmat(M,1,p-1))
    for (iD in 1:D){
      ay <- ap%*%sigma*sin(d) + (ay - t(repmat(mu,1,N)))*cos(d) + t(repmat(mu,1,N))
      ap <- ap*cos(d) - t(solve(sigma,t(ay) - repmat(mu,1,N)))*sin(d)
      if (iD != D){
        hay <- ay + h1*repmat(rowSums(ay),1,p-1)
        ap <- ap - d*(-hx + repmat(M/(1 + rowSums(exp(hay))),1,(p-1))*(exp(hay) - h1*matrix(1,N,p-1)) + h1*repmat(M,1,p-1))
      }
    }
    hay <- ay + h1*repmat(rowSums(ay),1,p-1)
    ap <- ap - d/2*(-hx + repmat(M/(1 + rowSums(exp(hay))),1,(p-1))*(exp(hay) - h1*matrix(1,N,p-1)) + h1*repmat(M,1,p-1))

    accept <- Accept_hmc.cond(x,M,ay,ap,by,bp,mu,sigma,h1)

    temp <- runif(N)
    y_store[temp<=accept,,mc+1] <- ay[temp<=accept,]
    y_store[temp>accept,,mc+1] <- by[temp>accept,]
  }
  return(y_store)
}
