###### LNM ######
require("MASS") # required by mvrnorm
LNM <- function(base, x, Iter1 = 5e3, samplenum = 5, HMC_burn = 1){
  r0 <- 1
  a <- 0.65

  ### Initialize all the parameters ###
  N <- nrow(x)
  p <- ncol(x)
  if (base != p){
    x <- x[,c(1:(base-1),(base+1):p,base)]
  }
  M <- rowSums(x)
  tx <- x
  tx[tx==0] <- 0.05
  y <- log(tx[,1:p-1]/tx[,p])
  mu <- colMeans(y)
  tt <- 5
  sigma <- cov(y) + tt*diag(p-1)
  T1 <- mu
  T2 <- sigma + T1%*%t(T1)
  Iter2 <- samplenum + 1
  R <- Iter2 - HMC_burn

  for (em in 1:Iter1){    
    r <- r0/((em+1)^a)
    y_store <- HMCsampling(mu, sigma, y, x, Iter2)
    y <- y_store[,,Iter2] ### transfer the last sample to the next EM iteration
    ny_store <- y_store[,,(HMC_burn+1):Iter2]
    ny_store <- apply(ny_store,2,rbind)
    T1_add <- colSums(ny_store)/N/R
    T2_add <- t(ny_store)%*%ny_store/N/R
    T1 <- (1-r)*T1 + r*T1_add
    T2 <- (1-r)*T2 + r*T2_add
    sigma_0 <- sigma
    sigma <- T2 - T1%*%t(T1)
    dsigma <- norm(sigma_0-sigma,"f")
    mu_0 <- mu
    mu <- T1
    dmu <- norm.vec.2(mu_0-mu)

    stoprule1 <- dmu/norm.vec.2(mu_0)
    stoprule2 <- dsigma/norm(sigma_0,"f")
    if (stoprule1<5e-5 & stoprule2<1e-3){
      break
    }
  }

  return(list(LNM_mu = mu, LNM_sigma = sigma, LNM_y = y, LNM_step = em))
}

Prediction.LNM <- function(p, test, samplenum = 1e3, gap = 2e1, HMC_burn = 5e2) {
  current_file <- sprintf("analysisLNM_%d_%d.RData",p,test)
  load(current_file) # simu_x, base, LNM_mu, LNM_sigma, LNM_y
  Iter <- samplenum*gap + HMC_burn

  x <- simu_x
  N <- nrow(x)
  p <- ncol(x)
  mu <- LNM_mu
  sigma <- LNM_sigma
  y <- LNM_y
  y_store <- HMCsampling(mu, sigma, y, x, Iter)
  id <- seq(HMC_burn+1,Iter,gap)
  LNM_pi <- matrix(0,N,p)
  prenum <- length(id)
  for (i in 1:prenum) {
    id_y <- id[i]
    nsay <- cbind(y_store[,,id_y],rep(0,N))
    LNM_pi <- LNM_pi + exp(nsay)/repmat(rowSums(exp(nsay)),1,p)
  }
  LNM_pi <- LNM_pi/prenum

  if (base != p){
    LNM_pi <- LNM_pi[,c(1:(base-1),p,base:(p-1))]
  }

  return(LNM_pi)
}

### basic function
norm.vec.2 <- function(x) sqrt(sum(x^2))

repmat <- function(Mat, m1, n1) {
  Mat <- as.matrix(Mat)
  s1 <- rep(1:nrow(Mat),m1)
  t1 <- rep(1:ncol(Mat),n1)
  newMat <- as.matrix(Mat[s1,])
  newMat <- as.matrix(newMat[,t1])
  return(newMat)
}

Accept_hmc <- function(x, M, ay, ap, by, bp, mu, sigma){
  N <- nrow(x)
  p <- ncol(x)
  tempx <- x[,-p]
  log_pt1 <- rowSums(tempx*(ay - by))
  log_pt2 <- rowSums(-0.5*(ay*t(solve(sigma,t(ay) - 2*repmat(mu,1,N))) - by*t(solve(sigma,t(by) - 2*repmat(mu,1,N)))))
  log_pt3 <- M*log((1 + rowSums(exp(by)))/(1 + rowSums(exp(ay))))
  log_pt4 <- 0.5*rowSums((bp - ap)%*%sigma*(bp + ap))

  accept <- pmin.int(1,exp(log_pt1 + log_pt2 + log_pt3 + log_pt4))

  return(accept)
}

HMCsampling <- function(mu, sigma, y, x, Iter){
  N <- nrow(x)
  p <- ncol(x)
  M <- rowSums(x)
  D0 <- 6:15
  d0 <- seq(5.5e-2,6.5e-2,1e-3)
  LD <- length(D0)
  Ld <- length(d0)
  y_store <- array(0,dim=c(N,p-1,Iter))
  y_store[,,1] <- y
  for (mc in 1:(Iter-1)){
    rd <- sample(1:Ld,1)
    d <- d0[rd]
    rD <- sample(1:LD,1)
    D <- D0[rD]
    by <- y_store[,,mc]
    bp <- mvrnorm(N,rep(0,p-1),solve(sigma))
    ap <- bp
    ay <- by
    ap <- ap - d/2*(-x[,-p]+repmat(M/(1+rowSums(exp(ay))),1,(p-1))*exp(ay))
    for (iD in 1:D){
      ay <- ap%*%sigma*sin(d)+(ay-t(repmat(mu,1,N)))*cos(d)+t(repmat(mu,1,N))
      ap <- ap*cos(d)-t(solve(sigma,t(ay)-repmat(mu,1,N)))*sin(d)
      if (iD != D){
        ap <- ap - d*(-x[,-p]+repmat(M/(1+rowSums(exp(ay))),1,(p-1))*exp(ay))
      }
    }
    ap <- ap - d/2*(-x[,-p]+repmat(M/(1+rowSums(exp(ay))),1,(p-1))*exp(ay))
    accept <- Accept_hmc(x,M,ay,ap,by,bp,mu,sigma)
    temp <- runif(N)
    y_store[temp<=accept,,mc+1] <- ay[temp<=accept,]
    y_store[temp>accept,,mc+1] <- by[temp>accept,]
  }
  return(y_store)
}


