library("ComplexHeatmap")
library("circlize")
load("realresult.RData")
mycol <- c("white", "#084594")

#cairo_ps("heatmap1.eps", width=12, height=6)
pdf("heatmap1.pdf", width=12, height=6)
mat <- t(prop.mult)
col_fun <- colorRamp2(quantile(mat, c(0.01, 0.99)), mycol)
ht.mult <- Heatmap(mat, name="Mult", col=col_fun, column_title="Mult", cluster_rows=FALSE, cluster_columns=FALSE,
    row_names_side="left", row_names_gp=gpar(fontsize=5), show_column_names=FALSE)

mat <- t(log(prop.ln1))
col_fun <- colorRamp2(quantile(mat, c(0.01, 0.99)), mycol)
ht.ln1 <- Heatmap(mat, name="LN1", col=col_fun, column_title="LN1", cluster_rows=FALSE, cluster_columns=FALSE,
    show_row_names=FALSE, show_column_names=FALSE)

mat <- t(log(prop.ln2))
col_fun <- colorRamp2(quantile(mat, c(0.01, 0.99)), mycol)
ht.ln2 <- Heatmap(mat, name="LN2", col=col_fun, column_title="LN2", cluster_rows=FALSE, cluster_columns=FALSE,
    show_row_names=FALSE, show_column_names=FALSE)
draw(ht.mult + ht.ln1 + ht.ln2, row_title="Genus", column_title="Sample", column_title_side="bottom")
dev.off()

#cairo_ps("heatmap2.eps", width=12, height=6)
pdf("heatmap2.pdf", width=12, height=6)
mat <- t(log(prop.dm))
col_fun <- colorRamp2(quantile(mat, c(0.01, 0.99)), mycol)
ht.dm <- Heatmap(mat, name="DM", col=col_fun, column_title="DM", cluster_rows=FALSE, cluster_columns=FALSE,
    row_names_side="left", row_names_gp=gpar(fontsize=5), show_column_names=FALSE)

mat <- t(log(prop.lnm))
col_fun <- colorRamp2(quantile(mat, c(0.01, 0.99)), mycol)
ht.lnm <- Heatmap(mat, name="LNM", col=col_fun, column_title="LNM", cluster_rows=FALSE, cluster_columns=FALSE,
    show_row_names=FALSE, show_column_names=FALSE)

mat <- t(log(prop.lnmp))
col_fun <- colorRamp2(quantile(mat, c(0.01, 0.99)), mycol)
ht.lnmp <- Heatmap(mat, name="LNM+", col=col_fun, column_title="LNM+", cluster_rows=FALSE, cluster_columns=FALSE,
    show_row_names=FALSE, show_column_names=FALSE)
draw(ht.dm + ht.lnm + ht.lnmp, row_title="Genus", column_title="Sample", column_title_side="bottom")
dev.off()
