### Analyze real data ###
### the LNM model ###
source("LNM_real.r")
load("realdata.RData")
realdata_file1 <- "analysisLNM_real.RData"
lnm <- LNM(base, countdata)
lnm1 <- LNM(base, lean)
lnm2 <- LNM(base, obese)
LNM_mu <- lnm$LNM_mu
LNM_sigma <- lnm$LNM_sigma
LNM_y <- lnm$LNM_y
LNM_mu_1 <- lnm1$LNM_mu
LNM_sigma_1 <- lnm1$LNM_sigma
LNM_y_1 <- lnm1$LNM_y
LNM_mu_2 <- lnm2$LNM_mu
LNM_sigma_2 <- lnm2$LNM_sigma
LNM_y_2 <- lnm2$LNM_y
save(base, countdata, lean, obese, LNM_mu, LNM_sigma, LNM_y, LNM_mu_1, LNM_sigma_1, LNM_y_1, LNM_mu_2, LNM_sigma_2, LNM_y_2, file = realdata_file1)
prelnm <- Prediction.LNM(realdata_file1)
prop.lnm <- prelnm$LNM_pi
prop.lnm.1 <- prelnm$LNM_pi_1
prop.lnm.2 <- prelnm$LNM_pi_2
save(base, countdata, lean, obese, LNM_mu, LNM_sigma, LNM_y, prop.lnm, LNM_mu_1, LNM_sigma_1, LNM_y_1, prop.lnm.1, LNM_mu_2, LNM_sigma_2, LNM_y_2, prop.lnm.2, file = realdata_file1)

source("StabilityTest.r")
pvalue_lnm <- Two_sample_test(prop.lnm.1, prop.lnm.2)

# Get prediction of proportion matrix by other methods (mult, dm, ln1, ln2)
# Denote by prop.mult, prop.dm, prop.ln1, prop.ln2, prop.mult.1, prop.dm.1, prop.ln1.1, prop.ln2.1, prop.mult.2, prop.dm.2, prop.ln1.2, prop.ln2.2
# Save them in realdata_file1 

### the LNM+ model ###
source("LNMplus_real.r")
load("realdata.RData")
realdata_file2 <- "analysisLNMp_real.RData"
system("mkdir temp")
require("foreach")
require("doParallel")
cl <- makeCluster(70, outfile = "")
registerDoParallel(cl)
Runs <- 1
sub <- 7
Lk <- 10
mylist <- CVlist(Runs, sub, Lk)
testlist <- mylist
myre <- foreach(i = 1:nrow(testlist), .packages = c('MASS')) %dopar% {
  CV.PAR(base, countdata, lean, obese, testlist[i,])
}
stopCluster(cl)
lnmp <- LNMp.CV(base, countdata, lean, obese)
LNMp_nu <- lnmp$LNMp_nu
LNMp_D <- lnmp$LNMp_D
LNMp_z <- lnmp$LNMp_z
LNMp_nu_1 <- lnmp$LNMp_nu_1
LNMp_D_1 <- lnmp$LNMp_D_1
LNMp_z_1 <- lnmp$LNMp_z_1
LNMp_nu_2 <- lnmp$LNMp_nu_2
LNMp_D_2 <- lnmp$LNMp_D_2
LNMp_z_2 <- lnmp$LNMp_z_2
save(base, countdata, lean, obese, LNMp_nu, LNMp_D, LNMp_z, LNMp_nu_1, LNMp_D_1, LNMp_z_1, LNMp_nu_2, LNMp_D_2, LNMp_z_2, file = realdata_file2)
prelnmp <- Prediction.LNMp(realdata_file2)
prop.lnmp <- prelnmp$LNMp_pi
prop.lnmp.1 <- prelnmp$LNMp_pi_1
prop.lnmp.2 <- prelnmp$LNMp_pi_2
save(base, countdata, lean, obese, LNMp_nu, LNMp_D, LNMp_z, prop.lnmp, LNMp_nu_1, LNMp_D_1, LNMp_z_1, prop.lnmp.1, LNMp_nu_2, LNMp_D_2, LNMp_z_2, prop.lnmp.2, file = realdata_file2)

source("StabilityTest.r")
pvalue_lnmp <- Two_sample_test(prop.lnmp.1, prop.lnmp.2)
