library(ggplot2)
library(scales)

load("result50.RData") 
cond1 <- cond_lnm # condition number for the LNM method (cond_lnm)
load("result100.RData")
cond2 <- cond_lnm
load("result200.RData")
cond3 <- cond_lnm
cond.data <- stack(data.frame(cond1, cond2, cond3))
mycol <- c("#66c2a5", "#fc8d62", "#8da0cb")
mylab <- c(bquote(~italic(p)==50), bquote(~italic(p)==100), bquote(~italic(p)==200))

#cairo_ps("cond.eps", width=6, height=4.5)
pdf("cond.pdf", width=6, height=4.5)
ggplot(cond.data, aes(values)) + geom_density(bw="SJ", aes(group=ind, linetype=ind, color=ind, fill=ind), alpha=0.2) +
    geom_hline(yintercept=0, color="white") +
    xlab("Condition number") + ylab("Density") + ylim(0,NA) +
    scale_x_log10(lim=10^c(2.3,5.2), breaks=trans_breaks("log10", function(x) 10^x, n=3), labels=trans_format("log10", math_format(10^.x))) +
    scale_linetype_manual(values=c("solid","longdash","dashed"), labels=mylab) + scale_color_manual(values=mycol, labels=mylab) +
    scale_fill_manual(values=mycol, labels=mylab) +
    theme_bw() +
    theme(panel.grid.major=element_blank(), panel.grid.minor=element_blank(),
          axis.title=element_text(size=rel(1.2)), axis.text=element_text(size=rel(1.1), color="black"),
          legend.position=c(0.88,0.88), legend.title=element_blank(), legend.text=element_text(size=rel(1.1)))
dev.off()
