require("MASS") # required by mvrnorm
require("stats") # required by rmultinom

Simu_data <- function(p, n, Runs){ # p = 50,100,200; n = 100; Runs = 100
  rho <- 0.5
  tt <- repmat(1:p,1,p)
  l <- abs(tt - t(tt))
  simu_omega <- rho^l
  lower_m <- 20*p
  upper_m <- lower_m + 1e3
  for (id in 1:Runs) {
    simu_xi <- runif(p,0,10)
    F1 <- cbind(diag(p-1), rep(-1,p-1))
    simu_mu <- as.vector(simu_xi%*%t(F1))
    simu_sigma <- F1%*%simu_omega%*%t(F1)
    w <- mvrnorm(n,simu_xi,simu_omega)
    simu_pi <- exp(w)/repmat(rowSums(exp(w)),1,p)
    M <- sample(lower_m:upper_m,n,replace=TRUE)
    simu_x <- matrix(0,n,p)
    for (i in 1:n) {
      simu_x[i,] <- as.vector(rmultinom(1,M[i],prob=simu_pi[i,]))
    }
    base <- p
    save_file <- sprintf("simu_%d_%d.RData",p,id)
    save(simu_x, base, simu_mu, simu_sigma, simu_xi, simu_omega, simu_pi, file = save_file)
  }
}

### basic function
repmat <- function(Mat, m1, n1) {
  Mat <- as.matrix(Mat)
  s1 <- rep(1:nrow(Mat),m1)
  t1 <- rep(1:ncol(Mat),n1)
  newMat <- as.matrix(Mat[s1,])
  newMat <- as.matrix(newMat[,t1])
  return(newMat)
}
