library(ggplot2)

types.method <- 5
types.prop <- 10
typename <- c(rep("DM",types.prop), rep("LN1",types.prop), rep("LN2",types.prop), rep("LNM",types.prop), rep("LNM+",types.prop))
prop <- seq(0.9,0,-0.1)
prop <- rep(prop,types.method) # x

rejnum <- c(83,59,48,25,18,14,9,8,7,5,83,58,48,21,19,12,7,8,7,6,82,58,49,23,17,11,9,8,6,5,88,62,49,33,18,16,11,6,6,3,88,69,60,40,32,21,13,8,7,3)/100 # y
rejmat <- matrix(rejnum,types.method,types.prop, byrow=TRUE)
colnames(rejmat) <- as.character(seq(0.9,0,-0.1))
rownames(rejmat) <- c("DM","LN1","LN2","LNM","LNM+")
rej.data <- data.frame(typename,prop,rejnum)

#postscript("power.eps", width=6, height=4.5)
pdf("power.pdf", width=6, height=4.5)
ggplot(rej.data, aes(prop, rejnum, colour=typename, shape=typename)) + geom_point(size=2) +
    geom_line(aes(linetype=typename, colour=typename)) + scale_linetype_manual(values=c("dashed","dotted","longdash","dotdash","solid")) +
    xlab("Proportion") + ylab("Power") + scale_x_continuous(breaks=seq(0,0.8,0.2)) + scale_y_continuous(breaks=seq(0,0.8,0.2)) + theme_bw() +
    theme(panel.grid.major=element_blank(), panel.grid.minor=element_blank(),
          axis.title=element_text(size=rel(1.2)), axis.text=element_text(size=rel(1.1), colour="black"),
          legend.position=c(0.9,0.2), legend.title=element_blank(), legend.text=element_text(size=rel(1.1)))
dev.off()
