library(ggplot2)
load("realresult.RData") 
# prop.mult, prop.dm, prop.ln1, prop.ln2, prop.lnm, prop.lnmp
# prop.mult.1, prop.dm.1, prop.ln1.1, prop.ln2.1, prop.lnm.1, prop.lnmp.1
# prop.mult.2, prop.dm.2, prop.ln1.2, prop.ln2.2, prop.lnm.2, prop.lnmp.2

### Shannon’s index
Hsh <- function(prop){
  prop <- prop[which(prop!=0)]
  -sum(prop * log(prop))
}

### Simpson’s index
Hsp <- function(prop){
  sum(prop^2)
}

types <- 6
group <- c(rep(1,nrow(new1)), rep(2,nrow(new2)))
group <- rep(group,types)
nsample <- nrow(new1) + nrow(new2)
method <- c(rep("Mult",nsample), rep("DM",nsample), rep("LN1",nsample), rep("LN2",nsample), rep("LNM",nsample), rep("LNM+",nsample))

### Mult: the multinomial model with individual parameters pi
myprop.1 <- prop.mult.1
shM2.1 <- apply(myprop.1,1,Hsh)
spM2.1 <- apply(myprop.1,1,Hsp)
myprop.2 <- prop.mult.2
shM2.2 <- apply(myprop.2,1,Hsh)
spM2.2 <- apply(myprop.2,1,Hsp)
shM2 <- c(shM2.1, shM2.2)
spM2 <- c(spM2.1, spM2.2)

### DM
myprop.1 <- prop.dm.1
shDM.1 <- apply(myprop.1,1,Hsh)
spDM.1 <- apply(myprop.1,1,Hsp)
myprop.2 <- prop.dm.2
shDM.2 <- apply(myprop.2,1,Hsh)
spDM.2 <- apply(myprop.2,1,Hsp)
shDM <- c(shDM.1, shDM.2)
spDM <- c(spDM.1, spDM.2)

### LN1: replacing all zeros by 0.5
myprop.1 <- prop.ln1.1
shLN1.1 <- apply(myprop.1,1,Hsh)
spLN1.1 <- apply(myprop.1,1,Hsp)
myprop.2 <- prop.ln1.2
shLN1.2 <- apply(myprop.2,1,Hsh)
spLN1.2 <- apply(myprop.2,1,Hsp)
shLN1 <- c(shLN1.1, shLN1.2)
spLN1 <- c(spLN1.1, spLN1.2)

### LN2: adding a pseudocount of 1 to all counts
myprop.1 <- prop.ln2.1
shLN2.1 <- apply(myprop.1,1,Hsh)
spLN2.1 <- apply(myprop.1,1,Hsp)
myprop.2 <- prop.ln2.2
shLN2.2 <- apply(myprop.2,1,Hsh)
spLN2.2 <- apply(myprop.2,1,Hsp)
shLN2 <- c(shLN2.1, shLN2.2)
spLN2 <- c(spLN2.1, spLN2.2)

### LNM
myprop.1 <- prop.lnm.1
shLNM.1 <- apply(myprop.1,1,Hsh)
spLNM.1 <- apply(myprop.1,1,Hsp)
myprop.2 <- prop.lnm.2
shLNM.2 <- apply(myprop.2,1,Hsh)
spLNM.2 <- apply(myprop.2,1,Hsp)
shLNM <- c(shLNM.1, shLNM.2)
spLNM <- c(spLNM.1, spLNM.2)

### LNM+
myprop.1 <- prop.lnmp.1
shLNMp.1 <- apply(myprop.1,1,Hsh)
spLNMp.1 <- apply(myprop.1,1,Hsp)
myprop.2 <- prop.lnmp.2
shLNMp.2 <- apply(myprop.2,1,Hsh)
spLNMp.2 <- apply(myprop.2,1,Hsp)
shLNMp <- c(shLNMp.1, shLNMp.2)
spLNMp <- c(spLNMp.1, spLNMp.2)

sh.index <- c(shM2, shDM, shLN1, shLN2, shLNM, shLNMp)
sp.index <- c(spM2, spDM, spLN1, spLN2, spLNM, spLNMp)
sh.df <- data.frame(sh.index,group,method)
sp.df <- data.frame(sp.index,group,method)
sh.df$method <- factor(sh.df$method, levels=c("Mult","DM","LN1","LN2","LNM","LNM+"), ordered=TRUE)
sp.df$method <- factor(sp.df$method, levels=c("Mult","DM","LN1","LN2","LNM","LNM+"), ordered=TRUE)

#postscript("shannon.eps", width=6, height=4)
pdf("shannon.pdf", width=6, height=4)
ggplot(sh.df, aes(method, sh.index, fill=factor(group))) + geom_boxplot(outlier.size=-1) + xlab("Method") + ylab("Shannon's index") +
    scale_fill_discrete(breaks=c("1","2"), labels=c("Lean","Obese")) + theme_classic() +
    theme(axis.title=element_text(size=rel(1.2)), axis.text=element_text(size=rel(1.1), colour="black"), legend.title=element_blank(),
          legend.text=element_text(size=rel(1.1)))
dev.off()

#postscript("simpson.eps", width=6, height=4)
pdf("simpson.pdf", width=6, height=4)
ggplot(sp.df, aes(method, sp.index, fill=factor(group))) + geom_boxplot(outlier.size=-1) + xlab("Method") + ylab("Simpson's index") +
    scale_fill_discrete(breaks=c("1","2"), labels=c("Lean","Obese")) + theme_classic() +
    theme(axis.title=element_text(size=rel(1.2)), axis.text=element_text(size=rel(1.1), colour="black"), legend.title=element_blank(),
          legend.text=element_text(size=rel(1.1)))
dev.off()
