Two_sample_test <- function(x, y){
  colnames(x) <- colnames(y) <- c()
  p <- dim(x)[2]
  nx <- dim(x)[1]
  ny <- dim(y)[1]
  clr_x <- log(x) - repmat(rowSums(log(x)),1,p)/p
  clr_y <- log(y) - repmat(rowSums(log(y)),1,p)/p
  var_x <- apply(clr_x, 2, var)*(nx-1)/nx
  var_y <- apply(clr_y, 2, var)*(ny-1)/ny
  temp <- (colMeans(clr_y)-colMeans(clr_x))^2/(var_y/nx+var_x/ny)
  Mclr <- max(temp)
  id <- which.max(temp)

  p_clr <- 1-exp(-1/sqrt(pi)*exp(-(Mclr-(2*log(p)-log(log(p))))/2))

  return(p_clr)
}

Swap <- function(realdata_file, percent, Runs){# maintain 1-percent
  load(realdata_file)
  for (test in 1:Runs) {
    if (percent>0){
      N1 <- nrow(lean)
      N2 <- nrow(obese)
      num1 <- round(N1*percent)
      num2 <- round(N2*percent)
      id1 <- sample(1:N1,num1)
      id2 <- sample(1:N2,num2)
      pool <- rbind(lean[id1,],n2[id2,])
      new1 <- lean[-id1,]
      new2 <- obese[-id2,]
      tid1 <- sample(1:(num1+num2),num1)
      new1 <- rbind(new1,pool[tid1,])
      new2 <- rbind(new2,pool[-tid1,])
    } else {
      new1 <- lean
      new2 <- obese
    }
    save_file <- sprintf("swap%d_%d.RData",round(10*percent),test)
    save(base, new1, new2, file = save_file)
  }
}

### basic function
repmat <- function(Mat, m1, n1) {
  Mat <- as.matrix(Mat)
  s1 <- rep(1:nrow(Mat),m1)
  t1 <- rep(1:ncol(Mat),n1)
  newMat <- as.matrix(Mat[s1,])
  newMat <- as.matrix(newMat[,t1])
  return(newMat)
}
