rm(list = ls())
source("func.R")
source("gen.R")
library(gtools)
library(igraph)
library(ggplot2)
library(flexclust)
# true gamma G0; D * V matrix 
gamma1 <- c(seq(0.005,1,0.005))
gamma2 <- c(gamma1[1:(length(gamma1)/2)], rev(gamma1[(length(gamma1)/2+1): length(gamma1)]))
gamma3 <- c(rev(gamma1[1:(length(gamma1)/2)]), gamma1[(length(gamma1)/2+1): length(gamma1)])

D1 <- 150
D2 <- 150
D3 <- 150
labelstrue <- c(rep(1,D1),rep(2,D2),rep(3,D3))
V <- length(gamma1)
D <- D1+D2+D3
eta <- 1
true.G <- rbind(matrix(gamma1,D1,V,byrow=TRUE),matrix(gamma2,D2,V,byrow = TRUE),matrix(gamma3,D3,V,byrow = TRUE))

# 0.06 ????,0.01????

data.edge <- simul(true.G, Mmin = 80, Mmax = 120, alpha1 = 0.08, alpha2 = 0.01, graph.type = "edge", seed = TRUE)
graph.edge <- data.edge$graph.s
plot.vert(graph.edge, D1, D2, D3, col = c('coral2','aquamarine','cadetblue4'))
data <- data.edge

# #small_world
# data.sw <- simul(true.G, Mmin = 80, Mmax = 120, graph.type = 'small_world', nei = 10, prob = 0.1, seed = TRUE)
# graph.sw <- data.sw$graph.s
# plot.vert(graph.sw, D1, D2, D3, col = c('coral2', 'aquamarine', 'cadetblue4'))
# data <- data.sw

w <- data$w
E <- data$E;print(E[1:10, ])
xi <- data$xi
Ebynode <- data$Ebynode
net.dis <- data$net.dis
net.data <- data$net.data
density.grh <- data$density.grh;density.grh
groupdata <- NULL
for (num in 1:3){groupdata[[num]] = seq((1+D1*(num-1)), num*D1)}
adj <- cal.adj(E, D)



cv.result <- net.cv(w, E, adj, net.dis, Ebynode, D1, D2, D3, method = 'DM', itvl = 0.98, lambda.max = 20, rho = 1000, net.type = 'net2', seeds = 2)
result <- admm.norm(w, E, Ebynode, xi, lambda= 19, rho = 1000, method='DM', s = 1.e-5)


grps <- clus.into.grp( result$z, E, Ebynode, result$lambda, del.vec = NULL, s = result$s)
plot.vert(grps$graph.g, D1, D2, D3, mode = 'admm', col = c('coral2','aquamarine','cadetblue4'), lambda = result$lambda, rho = result$rho, type = result$type)
group <- grps$group;group;length(group)
labels <- label(group);labels
measures(labels, D1, D2, D3)

# the mean and variance of the prediction error after 100 simulations
Bigve.list <- cal.ve(true.G, D1, D2, D3, net.type = "net1", method = "DM+")
meas.matrix <- meas.mat(D1, D2, D3, net.type = "net2")
file.E <- 'net2_plot/E.csv'
file.w <- 'net2_plot/w.csv'
file.labels <- 'net2_plot/labels.csv'
file.labelstrue <- 'net2_plot/labelstrue.csv'
write.csv(E, file = file.E)
write.csv(w, file.w, row.names = FALSE)
write.csv(labels, file.labels, row.names = FALSE)
write.csv(labelstrue, file.labelstrue, row.names = FALSE)

