rm(list=ls())
library("grid")
library("gridExtra")
library("cowplot")
source("func.R")
source("gen.R")
file.w = "w.txt"
# write.table(w, file.w, row.names = FALSE)
w = as.matrix(read.table(file.w, header=TRUE, sep = " ",as.is=F))
gamma1 = c(seq(0.005,1,0.005))
gamma2 = c(seq(1,0.005,-0.005))
gamma3 = c(seq(0.505,1,0.005),seq(0.005,0.5,0.005))
D1 = D2 = D3 = 100
labelstrue = c(rep(1,D1),rep(2,D2),rep(3,D3))
V = length(gamma1)
D = D1+D2+D3
true.G = rbind(matrix(gamma1,D1,V,byrow=TRUE),matrix(gamma2,D2,V,byrow=TRUE),matrix(gamma3,D3,V,byrow=TRUE))

pdf("prob.pdf", width=5.2, height=4)
compare.plot(w, gamma1, gamma2, gamma3)
dev.off()
# Save plot.
#ggsave("../plot_compare.png",myplot1 )

pdf("citeseer_legend.pdf", width=1, height=2)
df <- data.frame(x=rnorm(6), y=rnorm(6), Group=c("Agents", "AI", "DB", "HCI", "IR", "ML"))
gg <- ggplot(df, aes(x, y, color=Group)) + geom_point(size=4) + theme_classic() +
             scale_color_manual(values=c("#00CAFF", "#FF5C81", "#C686E9", "#806B68", "#5FC613", "#EA8615"))
legend <- get_legend(gg)
grid.newpage()
grid.draw(legend)
dev.off()

pdf("cora_legend.pdf", width=1, height=2)
df <- data.frame(x=rnorm(7), y=rnorm(7), Group=c("CB", "GA", "NN", "PM", "ReL", "RuL", "Theory"))
gg <- ggplot(df, aes(x, y, color=Group)) + geom_point(size=4) + theme_classic() +
             scale_color_manual(values=c("#806B68", "#00C7FF", "#E28BFF", "#69C404", "#FF5D85", "#00AF87", "#FA9200"))
legend <- get_legend(gg)
grid.newpage()
grid.draw(legend)
dev.off()
