# path = setwd("~/Desktop/bye/Xin_CSDA/code1")
# setwd(path)

# data generation 
simul <- function(true.G, Mmin=80, Mmax=120, alpha1 = 0.06,alpha2 = 0.01,
                  graph.type="edge", nei, prob, seed = TRUE){
  # true.G : true gamma; D * V
  D = nrow(true.G)
  V = ncol(true.G)
  if (seed == TRUE){set.seed(3)}
  dono = sample(Mmin:Mmax,D,replace = TRUE)
  beta0 = w = matrix(0,D,V)
  
  cat('Generating multinomial param. and doc.\n')
  for (d in 1:D) {
    beta0[d,] = rdirichlet(1, true.G[d,])
    w[d,] = rmultinom(1, dono[d], beta0[d,])
  }
  
  cat('Generating doc. network.\n')
  net.data = w/matrix(dono, D, V) 
  net.dis = as.matrix(dist(net.data))
  if(!is.na(match(graph.type, "edge"))){
    E.all = cbind(t(combn(1:D, 2)), 0)
    for (i in 1:nrow(E.all)) {
      U = c(E.all[i,1], E.all[i,2])
      if(length(intersect(U, 1:D1)) == 2|length(intersect(U,(1+D1):(D1+D2))) == 2|length(intersect(U, (D1+D2+1):D))==2){
        if (rbinom(1,1,alpha1) == 1){E.all[i,3] = 1}else{E.all[i, 3] = 0}
      }else {
        if (rbinom(1,1,alpha2) == 1){E.all[i,3] = 1}else{E.all[i, 3] = 0}
      }
    }
    E = E.all[which(E.all[,3] == 1),1:2]
    temp = cal.weight(w, E, eta)
  }
  if (!is.na(match(graph.type, "small_world"))) {
    g = watts.strogatz.game(1, D, nei,p=prob)
    E = get.edgelist(g)
    temp = cal.weight(w, E, eta)
  }
  
  graph.s = graph.edgelist(E, directed=FALSE)
  density.grh = graph.density(graph.s)
  cat('Generating a list.\n')
  Ebynode = vector("list", D)
  for (i in 1:D) Ebynode[[i]] = rep(0, 0)
  for (i in 1:nrow(E)){
    Ebynode[[E[i, 1]]] = c(Ebynode[[E[i, 1]]], E[i, 2])
    Ebynode[[E[i, 2]]] = c(Ebynode[[E[i, 2]]], E[i, 1])
  }
  adj=matrix(0, D, D)
  xi = temp$xi
  rownames(w) = 1:D
  return(list(true.G = true.G, beta0 = beta0, w = w, E = E, Ebynode = Ebynode, xi = xi, net.dis = net.dis,
              density.grh = density.grh,graph.s = graph.s, net.data = net.data))
}

