rm(list=ls())
path = getwd()
setwd(path)
source("func.R")
source("gen.R")

file_content = 'cora/cora.content.txt'
file_cites = 'cora/cora.cites.txt'

W_df = read.csv(file_content, header = FALSE)
ID = W_df[,1]
names(ID) = 1:length(ID)
Edge = read.csv(file_cites, header = FALSE)
tempE = matrix(0,nrow = nrow(Edge),ncol = ncol(Edge))
for (e in 1:nrow(Edge)){
  temp1 = which(ID==as.character(Edge[e,1]))
  temp2 = which(ID==as.character(Edge[e,2]))
  if (temp1<temp2){tempE[e,1] = temp1;tempE[e,2] = temp2}else{
    tempE[e,2] = temp1;tempE[e,1] = temp2
  }
}
E=plyr::count(tempE, names(tempE))[,1:2]
E = as.matrix(E)

W_origin = data.matrix(W_df[ ,2:(ncol(W_df)-1)])
W = W_origin[,which((colSums(W_origin)<250)==T)]
W = W_origin[,which((colSums(W_origin)>30)==T)]
D = nrow(W)
V = ncol(W);V
adj=matrix(0,D,D)
for (e in 1:nrow(E)){
  adj[E[e,1],E[e,2]]=1
  adj[E[e,2],E[e,1]]=1
}
lst=which(rowSums(adj)==0) # ??��??
Ebynode = vector("list", D)
for (i in 1:D) Ebynode[[i]] = rep(0,0)
for (i in 1:nrow(E)){
  Ebynode[[E[i,1]]] = c(Ebynode[[E[i,1]]], E[i,2])
  Ebynode[[E[i,2]]] = c(Ebynode[[E[i,2]]], E[i,1])
}
miss = which(rowSums(W)==0);miss
for (i in 1:length(miss)){
  if (length(Ebynode[[miss[i]]])==1){
    W[miss[i],] = W[Ebynode[[miss[i]]],]+1
  }else{
    W[miss[i],] = round(colMeans(W[Ebynode[[miss[i]]],]))+1
  }
}


groupCora = NULL
classes = c('Neural_Networks','Rule_Learning','Probabilistic_Methods','Reinforcement_Learning','Theory','Genetic_Algorithms','Case_Based')
for (i in 1:length(classes)){
  groupCora[[i]] = which((W_df[,ncol(W_df)]==classes[i])==T)
}
labelreal = c(rep(1,length(groupCora[[1]])),rep(2,length(groupCora[[2]])),rep(3,length(groupCora[[3]])),
              rep(4,length(groupCora[[4]])),rep(5,length(groupCora[[5]])),rep(6,length(groupCora[[6]])),rep(7,length(groupCora[[7]])))
net.data = W/matrix(rowSums(W),D,V)
net.dis = as.matrix(dist(net.data))
xi=1/net.dis[E]^3
rownames(W) = 1:nrow(W)
result = admm.norm(W, E, Ebynode, xi,lambda= 52,rho = 1500,method='DM+',s = 1.e-5)

grps = clus.into.grp(result$z,E,Ebynode,result$lambda,del.vec = NULL,s = result$s)
groups = grps$group
labels=label(groups)
groupdata = groupCora
accuracy = sensitivity = specificity = EMCC = Fvalue = precision = errorlst=ve= NULL
BigList = measures(D,groupdata,labels,ve,errorlst,accuracy,sensitivity, specificity,EMCC,Fvalue,precision)
lst=NULL;l=0;m=0;errornum=0;D1=818;D2=180;D3=426;D4=217;D5=351;D6=418;D7=298
for (j in 1:length(groups)){if (length(groups[[j]])>=70){lst=c(lst,j)}};lst


