

libname d 'C:\Documents and Settings\i0034827\Desktop\SAS-3';

proc sort data=d.vs out=vs; by usubjid visitnum;run;

proc transpose data=vs out=vs_t;
	var sbp dbp hr;
	by usubjid arm visitnum;
run;

data vs;
	set vs_t;
	if upcase(_name_)='SBP' then vs=1;
	if upcase(_name_)='DBP' then vs=2;
	if upcase(_name_)='HR' then vs=3;
	value=col1;
keep usubjid arm visitnum vs value;
run;

proc sort;by usubjid arm vs visitnum;run;

data vs;
	set vs;
	by usubjid arm vs visitnum;
	retain base;
	if visitnum=1 then base=value;
run;

data vs;
	set vs;
	chg=value-base;
run;

	proc sort data=vs;
	by arm vs visitnum;
	run;

	proc univariate data=vs noprint;
		var value chg;
		output out=m_vs n=n1-n2 mean=mean1-mean2 std=sd1-sd2 
                              median=median1-median2 min=min1-min2 max=max1-max2;
		by arm vs visitnum;
	run;

proc sort;by vs arm visitnum;run;

  OPTIONS;

  OPTIONS NODATE              
          NONUMBER        
          CENTER             
          MISSING     = ' '   
          LINESIZE    = 256            
          PAGESIZE    = 100            
          FORMCHAR    = '|____|+|___+=|_/\<>*'   
          PAPERSIZE   = A4                    
		  ORIENTATION = LANDSCAPE
;

ODS pdf FILE = "C:\Documents and Settings\i0034827\Desktop\SAS-3\f_vs.pdf";

title;
footnote;

goptions reset=all
	         cback=white
	         colors=(black) 
		     gunit=pct 
	         rotate=landscape
			htext=3; 

symbol1 i=join h=3 value=circle;
symbol2 i=join h=3 value=square;

axis1 offset=(2,2) 
       order=(1 to 5 by 1) 
      label=(justify=center h=3 'Visit' )  
	  value=(h=3 'Baseline' 'Week 1' 'Week2' 'Week4' 'Week6')
	  minor=none
      width=3; 

axis2 offset=(2,2) 
       order=(110 to 120  by 2)        /* for SBP */
      label=(justify=center angle=90 h=3  'SBP (mmHg)' )  
	  minor=none
      width=3; 

axis3 offset=(2,2) 
       order=(70 to 80  by 2)         /* for DBP */
      label=(justify=center angle=90 h=3  'DBP (mmHg)' )  
	  minor=none
      width=3; 

axis4 offset=(2,2) 
       order=(70 to 80  by 2)         /* for HR */
      label=(justify=center angle=90 h=3  'HR (bpm)' )  
	  minor=none
      width=3; 

legend1 value=(h=3 'Test' 'Control') 
	   label=(h=3 'Treatment:')
	   frame
	   down=1; 

proc gplot data=m_vs (where=(vs=1));
plot mean1*visitnum=arm/
					haxis=axis1 vaxis=axis2 legend=legend1;

title1;
title2 h=3 j=l "Sponsor: ABC"   j=r "&sysdate9.";
title3 h=3 j=l "Protocol: ABC123" j=r "1";
title4 h=3 j=c "Figure  1";
title5 h=3 j=c "Vital Signs : SBP (mmHg)";

run;
quit;

proc gplot data=m_vs (where=(vs=2));
plot mean1*visitnum=arm/
					haxis=axis1 vaxis=axis3 legend=legend1;
title1;
title2 h=3 j=l "Sponsor: ABC"   j=r "&sysdate9.";
title3 h=3 j=l "Protocol: ABC123" j=r "1";
title4 h=3 j=c "Figure  1";
title5 h=3 j=c "Vital Signs : DBP (mmHg)";

run;
quit;

proc gplot data=m_vs (where=(vs=3));
plot mean1*visitnum=arm/
					haxis=axis1 vaxis=axis4 legend=legend1;
title1;
title2 h=3 j=l "Sponsor: ABC."   j=r "&sysdate9.";
title3 h=3 j=l "Protocol: ABC123" j=r "1";
title4 h=3 j=c "Figure  1";
title5 h=3 j=c "Vital Signs : HR (bpm)";

run;
quit;


ODS pdf CLOSE;
ODS LISTING;


=l "Sponsor: ABC"   j=r "&sysdate9.";
title3 h=3 j=l "Protocol: ABC123" j=r "1";
title4 h=3 j=c "Figure  1";
title5 h=3 j=c "Vital Signs : DBP (mmHg)";

run;
quit;

proc gplot data=m_vs (where=(vs=3));
plot mean1*visitnum=arm/
					haxis=axis1 vaxis=axis4 legend=legend