

libname d 'C:\Documents and Settings\i0034827\Desktop\SAS-3';


**** convert the data from horizontal to vertical, it is easy to analysis multiple parameters ****;

proc sort data=d.vs out=vs; by usubjid visitnum;run;

proc transpose data=vs out=vs_t;
	var sbp dbp hr;
	by usubjid arm visitnum;
run;

data vs;
	set vs_t;
	if upcase(_name_)='SBP' then vs=1;
	if upcase(_name_)='DBP' then vs=2;
	if upcase(_name_)='HR' then vs=3;
	value=col1;
keep usubjid arm visitnum vs value;
run;

proc sort;by usubjid arm vs visitnum;run;

**** calculate the change from baseline, we need the additional variable for baseline  value****;

data vs;
	set vs;
	by usubjid arm vs visitnum;
	retain base;
	if visitnum=1 then base=value;
run;

data vs;
	set vs;
	chg=value-base;
run;

	proc sort data=vs;
	by arm vs visitnum;
	run;

**** descriptive analysis ****;

	proc univariate data=vs noprint;
		var value chg;
		output out=m_vs n=n1-n2 mean=mean1-mean2 std=sd1-sd2 
                              median=median1-median2 min=min1-min2 max=max1-max2;
		by arm vs visitnum;
	run;

**** customize the output format ****;

	data m_vs;
	   	set m_vs;

		col11=put(n1,3.);
		col12=put(mean1,5.1);
		col13=put(sd1,5.1);
		col14=put(median1,5.1);
		col15=put(min1,3.);
		col16=put(max1,3.);

		col21=put(n2,3.);
		col22=put(mean2,5.1);
		col23=put(sd2,5.1);
		col24=put(median2,5.1);
		col25=put(min2,3.);
		col26=put(max2,3.);

		if visitnum=1 then do;
			col21=' ';
			col22=' ';
			col23=' ';
			col24=' ';
			col25=' ';
			col26=' ';
		end;

		index=1;
		
		keep index arm vs visitnum col11-col16  col21-col26 ;
	run;

**** add a blank column between "observation" and "change from baseline" ****;

data final;
set m_vs;
x=' ';
run;

proc sort;by vs arm visitnum;run;

  OPTIONS;

  OPTIONS NODATE              
          NONUMBER        
          CENTER             
          MISSING     = ' '   
          LINESIZE    = 256            
          PAGESIZE    = 100            
          FORMCHAR    = '|____|+|___+=|_/\<>*'   
          PAPERSIZE   = A4                    
		  ORIENTATION = LANDSCAPE
;

  ODS ESCAPECHAR = '^'; 

  PROC TEMPLATE;
     DEFINE STYLE TLGs;
       PARENT = STYLES.RTF;
          REPLACE FONTS  "Fonts used in the style" /
                'TitleFont2'          = ("Times New Roman", 9.7pt)
                'TitleFont'           = ("Times New Roman", 9.7pt)
                'StrongFont'          = ("Times New Roman", 9.7pt)
                'EmphasisFont'        = ("Times New Roman", 9.7pt)
                'headingEmphasisFont' = ("Times New Roman", 9.7pt)
                'headingFont'         = ("Times New Roman", 9.7pt, BOLD)
                'docFont'             = ("Times New Roman", 9.7pt)
                'EmphasisFont'        = ("Times New Roman", 9.7pt)
                'FixedEmphasisFont'   = ("Times New Roman", 9.7pt)
                'FixedStrongFont'     = ("Times New Roman", 9.7pt)
                'FixedHeadingFont'    = ("Times New Roman", 9.7pt)
                'BatchFixedFont'      = ("Times New Roman", 9.7pt)
                'FixedFont'           = ("Times New Roman", 9.7pt)
                ;
          STYLE TABLE FROM TABLE  "Controls overall table style." /
                RULES                 = GROUPS    
                FRAME                 = VOID      
                CELLPADDING           = 0.0pt   
                CELLSPACING           = 0.0pt   
                BORDERWIDTH           = 1.0pt  
                PROTECTSPECIALCHARS   = OFF
                ;
          REPLACE BODY FROM DOCUMENT  "Controls the Body file." /
                TOPMARGIN             = 1.5 cm
                BOTTOMMARGIN          = 1.5 cm
                LEFTMARGIN            = 2.0 cm
                RIGHTMARGIN           = 2.0 cm
                PROTECTSPECIALCHARS   = OFF
                ;
          END;
  RUN;

ODS RTF FILE        = "C:\Documents and Settings\i0034827\Desktop\SAS-3\T_vs.rtf"
		STYLE	= TLGs
        AUTHOR      = "Li You"
        TITLE       = "Protocol: ABC123"
        HEADERY     = 568 /* Header 1.0 cm */
        FOOTERY     = 568 /* Footer 1.0 cm */
        STARTPAGE   = NEVER
        NOBODYTITLE
        SASDATE
        NOTOC_DATA
        NOCONTENTS;

title;
footnote;

title1 j=l "Sponsor: ABC"     j=r "&sysdate9.";
title2 j=l "Protocol: ABC123" j=r "^{thispage}";
title3 j=c "Table  1";
title4 j=c "Vital Signs";

proc format;
	value vsf
		1='SBP (mmHg)'
		2='DBP (mmHg)'
		3='HR (bpm)';
	value armf
		1='Test'
		2='Control';
	value visf
		1='Baseline'
		2='Week 1'
		3='Week 2'
		4='Week 4'
		5='Week 6';
run;

PROC REPORT DATA=final SPLIT="#" NOWINDOWS HEADLINE MISSING;

  COLUMN vs arm visitnum
      ("^R/RTF'\brdrb\brdrhair' Observation"
      (col11-col16)) x
      ("^R/RTF'\brdrb\brdrhair' Change from Baseline"
      (col21-col26));

    DEFINE vs        /order order=internal format=vsf. STYLE(COLUMN)=[CELLWIDTH =  2.0cm JUST=L] " ";
    DEFINE arm         /order order=internal format=armf.  STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=L] " ";
    DEFINE visitnum    /order order=internal format=visf.  STYLE(COLUMN)=[CELLWIDTH =  2.0cm JUST=L] " ";

	DEFINE col11        /display              STYLE(COLUMN)=[CELLWIDTH =  1.0cm JUST=C] "N";
    DEFINE col12        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Mean";
    DEFINE col13        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "SD";
    DEFINE col14        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Median";
    DEFINE col15        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Min";
    DEFINE col16        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Max";

	DEFINE x            /display              STYLE(COLUMN)=[CELLWIDTH =  0.5cm JUST=L]  " ";

	DEFINE col21        /display              STYLE(COLUMN)=[CELLWIDTH =  1.0cm JUST=C] "N";
    DEFINE col22        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Mean";
    DEFINE col23        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "SD";
    DEFINE col24        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Median";
    DEFINE col25        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Min";
    DEFINE col26        /display              STYLE(COLUMN)=[CELLWIDTH =  1.5cm JUST=C] "Max";

	compute after arm;
		line @1 " ";
	endcomp;

RUN;

ODS RTF CLOSE;
ODS LISTING;

