proc tabulate data=samp.vs;
  class usubjid siteid arm visitnum;
  table usubjid, n;
  table siteid, n;
  table arm,n;
  table visitnum, n;
  tables usubjid, siteid;
run;
/* How to calculate changes from baseline? */
proc sql;
  create table vs as
    select * from samp.vs;
  select unique usubjid from vs;
  select count(*) from(
    select unique usubjid from vs);
  select unique siteid from vs;
  select unique arm from vs;
quit;



data vs0;
  set samp.vs;
  if visitnum=1;
run;

proc sort data=vs0; by usubjid;

proc sort data=samp.vs out=vs1; by usubjid;

data vs2(rename=(sbp=sbp0 dbp=dbp0 hr=hr0));
  set vs0(keep=usubjid sbp dbp hr);
run;

data vs3;
  merge vs1 vs2;
  by usubjid;
  sbp1 = sbp - sbp0;
  dbp1 = dbp - dbp0;
  hr1 = hr - hr0;
run;
 









proc means data=vs3 noprint;
    class arm visitnum;
	var sbp sbp0;
    output out=stat1(where=(_type_=3))
        n=n1 n2 mean=mean1 mean2
        std=sd1 sd2 median=median1 median2
         min=min1 min2 max=max1 max2;
run;

proc means data=vs3 noprint;
    class arm visitnum;
	var dbp dbp0;
    output out=stat2(where=(_type_=3))
        n=n1 n2 mean=mean1 mean2
        std=sd1 sd2 median=median1 median2
         min=min1 min2 max=max1 max2;
run;
proc means data=vs3 noprint;
    class arm visitnum;
	var hr hr0;
    output out=stat3(where=(_type_=3))
        n=n1 n2 mean=mean1 mean2
        std=sd1 sd2 median=median1 median2
         min=min1 min2 max=max1 max2;run;
data stat;
  set stat1(in=s1) stat2(in=s2) stat3(in=s3);
  if s1 then varname='SBP';
  if s2 then varname='DBP';
  if s3 then varname='HR';
run;
proc print data=stat;
   var varname arm visitnum 
     n1 mean1 sd1 median1 min1 max1
	 n2 mean2 sd2 median2 min2 max2;
run;

options nodate nonumber;
ods rtf file='testout1.rtf' nobodytitle;
title1  j=l "Sponsor: ABC"     j=r "&sysdate9.";
proc report data=stat nowindows;
   column varname arm visitnum 
     n1 mean1 sd1 median1 min1 max1
	 n2 mean2 sd2 median2 min2 max2;
	define varname / order ' ';
	define arm /order ' ' format=testcontrol.;
	define visitnum / ' ' format=visitf.;
	define n1 / 'N';
	define mean1 / 'Mean' format = 8.1;
	define sd1 / 'SD' format=8.1;
	define n2 / 'N';
	define mean2 / 'Mean' format = 8.1;
	define sd2 / 'SD' format=8.1;
run;
ods rtf close;

data statt;
  set stat;
  select (varname);
    when('SBP') varn=1;
    when('DBP') varn=2;
	when('HR') varn=3;
  end;
run;

proc format;
    value testcontrol 1='Test' 2='Control';
	value visitf 1='Baseline' 2='Week 1'
	  3='Week 2' 4='Week 4' 5='Week 6';
	value varf 1='SBP(mmHg)' 2='DBP(mmHg)'
	   3='HR(bpm)';
run;
proc report data=statt nowindows;
  column varn arm visitnum
    n1 mean1 sd1 median1 min1 max1
	n2 mean2 sd2 median2 min2 max2;
  define varn  / order ' ' format=varf. order=internal;
  define arm  / order ' ' format=testcontrol.;
  define visitnum / order ' ' format=visitf.;
  define n1 / 'N';
  define n2 / 'N';
  define mean1 / 'Mean' format=8.1;
run;
quit;


data new;
  set stat;
  where varname='SBP';
  keep visitnum mean1 arm;
run;
proc sort data=new;
  by visitnum arm ;
proc transpose data=new out=new1;
  var mean1;
  by visitnum;
  id arm;
run;

goptions reset=all
	         cback=white
	         colors=(black) 
		     gunit=pct 
	         rotate=landscape
			htext=3; 

axis1 offset=(2,2) 
       order=(1 to 5 by 1) 
      label=(justify=center h=3 'Visit' )  
	  value=(h=3 'Baseline' 'Week 1' 'Week2' 'Week4' 'Week6')
	  minor=none
      width=3; 
title;
legend1 value=(h=3 'Test' 'Control') 
	   label=(h=3 'Treatment:')
	   frame
	   down=1; 

proc gplot data=new1;
  symbol1 i=join h=3 value=circle;
  symbol2 i=join h=3 value=square;
  plot _1* visitnum=1 
    _2 * visitnum=2 / overlay
    haxis=axis1 legend=legend1;
run;
