### 在run里启动一个Timer计时线程 
from threading import Thread, Timer
import threading
from time import sleep

class MyThread1(Thread):
    num = 1
    def __init__(self): # 用name关键字给定进程名
        Thread.__init__(self, name="Sub-thread-"+str(MyThread1.num))
        MyThread1.num += 1
        
    def run(self):
        print(self.name + " starts.")
        t = Timer(2.0, self.timed_action)
        print("Create a timed thread.")
        t.start()
        sleep(1.0)
        print(self.name, "terminates.")

    def timed_action(self):
        print("Hello, I am the timed thread.")
        print("I am resumed now.")
        print("I am terminating...")
        
print("Main thread starts.")
th = MyThread1()
th.start()
sleep(0.5)
print(threading.enumerate())
sleep(1.0)
print(threading.enumerate())
print("Main thread treminates.")


##### 创建同一线程类的多个线程并让它们运行
##class Th1(Thread):
##    _num = 0
##    
##    def __init__(self):
##        Thread.__init__(self, name="sub-thread")
##        self.setName(self.getName() + "_" + str(Th1._num))
##        Th1._num += 1
##
##    def run(self):
##        for i in range(4):
##            n = 0
##            for j in range(100000):
##                n += j
##            print("{}:{}: {}\n".format(
##                self.getName(), str(i), str(n)))
##        print(self.getName() + " terminated.\n")
##
##for n in range(4):
##    th = Th1()
##    th.start()
##print("Main finished.\n")


#### 展示并发程序相对执行速度的非确定性
##def fprint(s):
##    print(s)
##
##class SubPrint(Thread):
##    def __init__(self, s):
##        Thread.__init__(self, name = "sub thread 1")
##        self._s = s
##        
##    def run(self):
##        for i in range(10):
##            t = Timer(0.2, lambda: fprint(self._s))
##            t.start()
##
##process = SubPrint("I am the sub thread.\n")
##process.start()
##for i in range(10):
##    t = Timer(0.2, lambda: fprint("I am main thread.\n"))
##    t.start()


#### 两个线程操作同一个全局变量
#### 说明进程之间合作可能出现的情况
##num = 0
##
##class Adder(Thread):
##    def __init__(self, name_):
##        Thread.__init__(self, name=name_)
##        
##    def run(self):
##        global num
##        for i in range(1000000):
##            num = num + 1
##
##th1 = Adder("Adder1")
##th1.start()
##th1.join() # 等待Adder1结束
##th2 = Adder("Adder2")
##th2.start()
##th2.join() # 等待Adder2结束
##print("Result:", num)


###### 两个线程对操作同一个全局变量，用Lock保护共享变量
###### Lock对象符合context manager的要求，用with很方便
##from threading import Lock
##lock1 = Lock()
##num = 0
##
##class Adder(Thread):
##    def __init__(self, name_):
##        Thread.__init__(self, name=name_)
##        
##    def run(self):
##        global num
##        for i in range(1000000):
##            with lock1:
##                num = num + 1
##
##th1 = Adder("Adder 1")
##th1.start()
##th2 = Adder("Adder 2")
##th2.start()
##th1.join()
##th2.join()
##print("Result:", num)


#### 展示Queue类对象使用的示例
##from queue import Queue
##
##glist = None
##
##class Producer(Thread):
##    def __init__(self, name_, queue, n):
##        Thread.__init__(self, name=name_)
##        self._queue = queue
##        self._num = n
##
##    def run(self): # 生产一些数据放入通讯队列
##        for i in range(self._num):
##            time.sleep(0.2)
##            self._queue.put((self.getName(), i))
##
##class Consumer(Thread):
##    def __init__(self, name_, queue, n):
##        Thread.__init__(self, name=name_)
##        self._queue = queue
##        self._num = n
##
##    def run(self): # 从队列中取出数据使用
##        global glist
##        list1 = []
##        for i in range(self._num):
##            list1.append(self._queue.get())
##        glist = list1
##        
##def main():
##    q = Queue() # 创建一个队列对象作为线程通讯通道
##    p1 = Producer("P1", q, 10) # 建立两个生产线程
##    p2 = Producer("P2", q, 10)
##    cons = Consumer("C1", q, 20) # 建立消费线程
##    p1.start()   # 启动三个线程
##    p2.start()
##    cons.start()
##    p1.join()    # 等待三个线程完成工作
##    p2.join()
##    cons.join()
##    print(glist) # 输出全局变量的值
##    
##main() 启动计算




