#### 展示Queue类对象使用的示例

from threading import Thread
from queue import Queue, Empty
from time import sleep
from random import random

glist = []

class Producer(Thread):
    def __init__(self, name_, queue_, n):
        Thread.__init__(self, name=name_)
        self._queue = queue_
        self._num = n

    def run(self): # 生产一些数据放入通讯队列
        for i in range(self._num):
            sleep(0.1 * random())
            self._queue.put((self.name, i))

class Consumer(Thread):
    def __init__(self, name_, queue):
        Thread.__init__(self, name=name_)
        self._queue = queue

    def run(self): # 从队列中取出数据使用
        while True:
            try:
                glist.append(self._queue.get(timeout=0.2))
            except Empty:
                break
        
q = Queue() # 创建一个队列对象作为线程通讯通道
Producer("P1", q, 10).start() # 建立两个生产线程
Producer("P2", q, 10).start()
cons = Consumer("C1", q) # 建立消费线程
cons.start()
cons.join()  # 等待消费线程结束
print(glist) # 输出全局变量 glist 的值





