##### 把一项工作分配给多个线程，最后汇集它们的结果

from threading import Thread, Lock

data_num = 10000
segment = data_num // 10
dlist = [i for i in range(data_num)]
llock = Lock()
threads = []

def fun(x): return x * x

class Calc(Thread):
    def __init__(self, begin, end):
        Thread.__init__(self)
        self._begin = begin
        self._end = end
        
    def run(self):
        for i in range(self._begin, self._end):
            x = fun(dlist[i])
            with llock:
                dlist[i] = x

for i in range(10):
    th = Calc(segment * i, segment * (i + 1))
    threads.append(th)
    th.start()
    
while threads:
    threads.pop().join()
    print("a sub-thread is terminated.")

s = 0
for i in range(data_num):
    s += dlist[i]
print("Summary:", s)
print("The work is completed.")
