###### 两个线程对操作同一个全局变量，用Lock保护共享变量
###### Lock对象符合context manager的要求，用with很方便
from threading import Thread, Lock

num = 0
lock = Lock()

class Adder(Thread):
    def __init__(self, name_):
        Thread.__init__(self, name=name_)
        
    def run(self):
        global num
        for i in range(1000000):
            with lock:
                num = num + 1

th1 = Adder("Adder1")
th1.start()
th2 = Adder("Adder2")
th2.start()
th1.join() # 等待Adder1结束
th2.join() # 等待Adder2结束
print("Result:", num)
