##### 创建同一线程类的多个线程并让它们运行

from threading import Thread
from random import randrange

def gcd(m, n):
    if m == 0:
        return n
    while n % m != 0:
        m, n = n % m, m
    return m

def pi_test():
    a = randrange(1, 2**31)
    b = randrange(1, 2**31)
    return gcd(a, b) == 1

def montecarlo(test, num):
    passed = 0
    for i in range(num):
        if pi_test():
            passed += 1
    return (passed, num)


class Pi_est(Thread):
    def __init__(self, num_test, q):
        Thread.__init__(self)
        self._num = num_test
        self._queue = q

    def run(self):
        self._queue.put(montecarlo(pi_test, self._num))

if __name__ == "__main__":
    
    def pi_value(passed, total):
        return (6 / (passed / total))**0.5

    from queue import Queue
    que = Queue()

    total, passed = 0, 0
    times = 10

    for i in range(times):
        Pi_est(randrange(10000, 20000), que).start()

    for i in range(times):
        p, t = que.get()
        print("Get", p, t)
        passed += p
        total += t

    print("Total tests:", total, "Total passed:", passed)
    print(pi_value(passed, total))
