## 电话簿程序的主模块
## 定义类 Phonebook

import pickle
from phone_GUI import UI

class Phonebook():
    def __init__(self, fbfile):
        self._ui = UI(self)
        self._fbfile = fbfile
        self._loadok = True
        
        try:
            with open(fbfile + ".pickle", "rb") as inf:
                self._phonebook = pickle.load(inf)  # 装入phonebook
        except:
            self._phonebook = {} # 没有这个文件，从空电话簿开始
            self._loadok = False
            
        self._ui.start(self._loadok)

    def add(self, name, num):
        if name in self._phonebook:
            return "名字重复"
        if not num.isdigit(): # 如果号码中有非数字字符
            return "电话号码包含非数字字符"
        self._phonebook[name] = num

    def lookup_name(self, name):
        try:
            num = self._phonebook[name]
            return (name, num)
        except: return None

    def lookup_num(self, num):
        for name, n in self._phonebook.items():
            if n == num: return (name, num)
        return None

    def save(self):
        with open(self._fbfile + '.pickle', 'wb') as outf:
            pickle.dump(self._phonebook, outf)

if __name__ == "__main__":
    Phonebook("phonebook")
