## 电话簿程序的正文界面模块

help_info = \
"""电话簿命令（请输入数字）：
1: 添加新联系人
2: 给定姓名查找电话号码
3: 给定电话号码查找姓名
4：存储当前电话簿
0: 结束工作
"""

class UI():
    def __init__(self, host):
        self._host = host
        self._commands = {
            "1": self.add,        "2": self.lookup_name,
            "3": self.lookup_num, "4": self.save_phonebook }

    def start(self, load_ok):
        if not load_ok:
            print("无法装入指定文件，用空电话簿.")
        print(help_info)
        while True:
            n = input("命令>> ")
            if n == "0":
                yesno = input("结束使用 (yes/no)？")
                if yesno.lower() in {"yes", "y"}: return
                continue

            try:
                self._commands[n]()
            except Exception as ex:
                print(ex)
                print(help_info)

    def add(self):
        name = input("联系人姓名：")
        num  = input("电话号码：")
        info = self._host.add(name, num)
        if info: print(info)

    def lookup_name(self):
        name  = input("联系人姓名：")
        entry = self._host.lookup_name(name)
        if entry: print(*entry)
        else: print("找不到这个联系人！")

    def lookup_num(self):
        num   = input("电话号码：")
        entry = self._host.lookup_num(num)
        if entry: print(*entry)
        else: print("找不到这个电话号码！")

    def save_phonebook(self):
        self._host.save()
            
            
   

