## 一个简单GUI程序，其中定义了一个简单的窗口类
## 窗口中显示两个按钮

import tkinter as tk

class ButtonWin(tk.Frame):
    def __init__(self):
        tk.Frame.__init__(self)
        self.master.title("Main");
        self.grid()
        self.createWidgets() # 调用方法设置窗口物件

    def createWidgets(self): # 在窗口里设置两个按钮
        self._hi = tk.Button(self) # 分别设置属性
        self._hi["text"] = "Hello World (click me)"
        self._hi["command"] = self._say_hi # 关联命令 _say_hi
        self._hi.grid() # 位置在上
        self._quit = tk.Button( # 创建时提供属性值
            self, text="QUIT", fg="red", 
            command=self.master.destroy) # 关联的命令是退出主窗口
        self._quit.grid() # 位置在下

    def _say_hi(self):
        print("hi there, everyone!")

ButtonWin().mainloop()
