## 简单的GUI程序，其中两个按钮，相互切换状态，用tttk实现

from tkinter import ttk

class TwoButtonWin(ttk.Frame):
    def __init__(self):
        """Sets up the window and widgets."""
        ttk.Frame.__init__(self)
        self.master.title("Button Win")
        self.grid()
        self._label = ttk.Label(self, text="Begin")
        self._label.grid(sticky="ew")
        self._button1 = ttk.Button(self, text="Coming",
                             command=self._switch, width=20)
        self._button1.grid(sticky="ew")
        self._button2 = ttk.Button(self, text="Leaving",
                             command=self._switch)
        self._button2.state(["disabled"])
        self._button2.grid(sticky="ew")
        self.mainloop()
        
    def _switch(self):
        """Event handler for the button."""
        if self._label["text"] == "Hello!":
            self._label["text"] = "Goodbye!"
            self._button1.state(["!disabled"])
            self._button2.state(["disabled"])
        else:
            self._label["text"] = "Hello!"
            self._button1.state(["disabled"])
            self._button2.state(["!disabled"])
            

TwoButtonWin()
