## 一个简单的有理数类

class Rational0:  # 采用大写开头的名字是惯例
    # 定义几个实例方法，其他类似
    def __init__(self, num, den=1):  # 创建对象时执行初始化方法
        self._num = num  # 设置实例的数据属性，用 _num 避免与方法同名
        self._den = den  # 一个对象里的属性不能重名
        
    def num(self):  # 访问有理数的数据属性，这里取出有理数的分子
        return self._num
    
    def den(self):  # 取出有理数的分母
        return self._den
    
    def plus(self, another):  # 计算，做加法
        den = self._den * another._den
        num = (self._num * another._den +
               self._den * another._num)
        return Rational0(num, den)
    
    def times(self, another):  # 计算，做乘法
        return Rational0(self._num * another._num,
                         self._den * another._den)

    def prt(self):
        print("(" + str(self._num)+"/"+str(self._den) + ")")


if __name__ == "__main__":
    r1 = Rational0(3, 5)
    r2 = Rational0(7, 15)
    r3 = r1.plus(r2)
    r4 = r3.times(Rational0(5, 6))
    r1.prt()
    r2.prt()
    r3.prt()
    r4.prt()

    print(type(r1))
    print(type(r1.plus))

    print()

    r5 = Rational0(25, 40)
    r6 = Rational0(1, -2)
    r7 = r1.plus(r6)
    r8 = r1.times(Rational0(-1, -2))
    r5.prt()
    r6.prt()
    r7.prt()
    r8.prt()
