# 本模块定义一个客户类和一个客户管理类
# 在客户对象中记录了客户消费的历史积累值

class Customer:
    def __init__(self, name):
        self._name = name
        self._total = 0.0

    def pay(self, price):
        self._total += price
        return price

    def total(self):
        return self._total

class CustomerManager:    
    _customers = {}

    @classmethod
    def new_customer(cls, name):
        if not isinstance(name, str):
            raise TypeError("Create Record Error: ", name)
        cls._customers[name] = Customer(name)

    @classmethod
    def pay_price(cls, name, price):
        if (not isinstance(name, str) or
            not isinstance(price, float)):
            raise TypeError("Purshese Error: ", name, price)
        if name not in cls._customers: # 无此客户时自动添加
            cls._customers[name] = Customer(name)
        return cls._customers[name].pay(price)

    @classmethod
    def check_total(cls, name):
        if name not in cls._customers:
            raise KeyError("No such customer: ", name)
        return cls._customers[name].total()


if __name__ == "__main__":
    c1 = Customer("Li Lei")
    c2 = Customer("Han Meimei")
    c3 = Customer("Zhang Shan")

    print("Li Lei spends: ", c1.pay(24.5))
    print("Han Meimei spends: ", c2.pay(28.7))
    print("Li Lei spends: ", c1.pay(7.85))

    print("Li lei spends totally: ", c1.total())
    print("Han Meimei spends totally: ", c2.total())

    cmanager = CustomerManager
    cmanager.new_customer("Li Lei")
    cmanager.new_customer("Han Meimei")
    cmanager.new_customer("Zhang Shan")

    print("Li Lei spends: ", cmanager.pay_price("Li Lei", 12.38))
    print("Li Lei spends: ", cmanager.pay_price("Li Lei", 18.35))
    print("Li Lei spends: ", cmanager.pay_price("Li Lei", 31.05))
    print("Li Lei spends totally:", cmanager.check_total("Li Lei"))
    
    
    
