#### 希望做一个函数，每次调用返回文件里的一个浮点数
#### 定义一对函数，一个函数打开文件，另一个函数调用一次返回一个浮点数
#### 没有更多浮点数时后移函数返回 None

infile = None
nlist = []
crt = 0

def open_floats(fname):
    global infile
    infile = open(fname)

def next_float(): # 缓冲式处理
    global nlist, crt
    if crt == len(nlist): # 一行已经用完
        line = infile.readline()
        if not line: # 整个文件已经处理完了
            infile.close()
            return None
        nlist = line.split()
        crt = 0
    crt += 1
    return float(nlist[crt - 1])


# 使用方式:
# 首先调用 open_floats(filename) 初始化相关功能
# 以后每次调用 next_float() 得到下一个浮点数

if __name__ == "__main__":
    ####简单运行实例：
    open_floats("data.dat")
    for i in range(10):
        print(next_float())
    print("\n")

    #### 输出属于区间 (20, 25) 的数，最后输出数据总数和输出数据的个数：
    open_floats("data.dat")
    num = 0
    printed = 0
    while True:
        x = next_float()
        if x == None:
            break
        num += 1
        if 25 > x > 20:
            print(x)
            printed += 1

    print("Read floats: ", num)
    print("Print floats: ", printed)

#### 缺点：用了几个全局变量，功能可能受到干扰
