#### 求兑换硬币的不同方式，递归定义的函数
#### 用 k 种硬币兑换 n 的不同方式等于
#### 用硬币 a 一次后兑换 n-a 的不同方式加不同 a 兑换 n 的方式

###### get_coins 对具体的 n 值启动计算

def exchange_coins(n):
    cases = []
    
    def amount(k): # amount 将硬币类 1 到 6 对应到具体币值
        if k == 1:
            return 1
        if k == 2:
            return 2
        if k == 3:
            return 5
        if k == 4:
            return 10
        if k == 5:
            return 50
        if k == 6:
            return 100
        assert False

    def xcoins(k, n, coins): # 核心函数 ccoins 递归地计算不同兑换方式
        nonlocal cases
        
        if n == 0:
            cases.append(coins)
            return
        if k == 0 or n < 0:
            return

        m = amount(k)
        xcoins(k, n - m, coins + [m])
            
        xcoins(k - 1, n, coins)
    
    xcoins(6, n, [])
    return cases

## 计算几种币值的兑换数

print(exchange_coins(0))
print(exchange_coins(1))
print(exchange_coins(10))

##for m in range(10, 12):
##    print("Exchange " + str(m) + ", we get", exchange_coins(m))
