## 用筛法求直到 n 的素数表
## 用一个表存储直到 n 的整数，从 2 开始，对每个已知素数，
## 将其倍数筛除（将对应位置的元素置 0）
##### sieve 生成直到 n 的素数表

def sieve(n):
    def sieve0(nlist):
        nlist[0] = nlist[1] = 0
        k = 2
        while k * k <= n:
            if nlist[k] != 0:
                for i in range(2 * k, n+1, k):
                    nlist[i] = 0
            k += 1
        return nlist
    
    def collect(nlist):
        primes = []
        for x in nlist:
            if x != 0:
                primes.append(x)
        return primes
    
    if n < 2:
        return []
    
    numbs = sieve0(list(range(n+1)))
    return collect(numbs)

print(sieve(100))


