# 有理数包

# 基础设置: 构造函数, 选择函数
# 求最大公约数，假定 m >= 0, n > 0

def gcd (m, n):
    if m % n == 0:
        return n
    return gcd(n, m % n)

def rational(n, d):
    assert isinstance(n, int) and isinstance(d, int) and d != 0
    sign = 1
    if n < 0:
        sign = -sign
        n = -n
    if d < 0:
        sign = -sign
        d = -d
        
    g = gcd(n, d)
    return sign * (n//g), d//g

def num(x):
    return x[0]

def den(x):
    return x[1]

# 基本有理数运算

def rat_minus(x):
    return rational(-num(x), den(x))

def rat_plus(x, y):
    n = num(x)*den(y) + num(y)*den(x)
    d = den(x)*den(y)
    return rational(n, d)       

def rat_sub(x, y):
    n = num(x)*den(y) - num(y)*den(x)
    d = den(x)*den(y)
    return rational(n, d)       

def rat_times(x, y):
    n = num(x)*num(y)
    d = den(x)*den(y)
    return rational(n, d)

def rat_divid(x, y):
    n = num(x) * den(y)
    d = den(x) * num(y)
    return rational(n, d)

def rat_print(x):
    print(str(num(x)) + "/" + str(den(x)))
# 有理数包结束

#### 下面是一些测试用例

##x = rational(7, 24)
##y = rational(3, 7)
##z = rational(13, 6)
##z0 = rational(0, 13)
##
##r1 = rat_plus(x, y)
##r2 = rat_plus(x, z)
##r3 = rat_times(r1, r2)
##r4 = rat_divid(r2, r3)
###r5 = rat_divid(r1, z0)

##rat_print(r1)
##rat_print(r2)
##rat_print(r3)
##rat_print(r4)
