#### 求整数的所有素因子，返回这些素因子的表

def prime_factors(n):
    def nextpf(n): # 给出下一个素因子
        d = 2
        while d * d <= n:
            if n % d == 0:
                return d
            d += 1
        return n

    flist = []
    while n != 1: # 反复求素因子并从 n 中除掉它
        p = nextpf(n)
        flist.append(p) # 在表中积累素因子
        n //= p

    return flist
