#### 计算前 n 个 Fibonacci 数中所有整除 3 的数之和

from list_processing import *

def fib(n):
    if n < 1:
        return 0
    f1, f2 = 0, 1 # F_0, F_1
    k = 0
    while k < n:
        f1, f2 = f2, f2 + f1
        k += 1
    return f1   

def fib_sum(n):
    return reduce(lambda x, y: x + y,
                  filter(lambda x: x % 3 == 0,
                         map(fib, list(range(n)))),
                  0)
