###### 牛顿法求函数的根
def newton(f, df, init):
    def improve(x1):
        return x1 - f(x1)/df(x1)
    
    x1 = init
    while True:
        x2 = improve(x1)
        if abs(f(x2)) < 1e-6:
            return x2
        x1 = x2

from math import sin, cos
print("newton(sin, cos, 1.0)")
print("We have:", newton(sin, cos, 1.0))
print("newton(cos, -sin, 1.9)")
print("We have:", newton(cos, lambda x: -sin(x), 1.9))
