#### 蒙特卡罗模拟程序（通用模拟框架）和实例

def montecarlo(test, num):
    passed = 0
    for i in range(num):
        if test():
            passed += 1
    return passed/num

# Suppose m >= 0, n > 0
def gcd(m, n):
    if m%n == 0:
        return n
    return gcd(n, m%n)

from random import randrange
def pi_test():
    a = randrange(1, 2**31)
    b = randrange(1, 2**31)
    return gcd(a, b) == 1

def my_test(num):
    return (6 / montecarlo(pi_test, num))**0.5
    
    
if __name__ == "__main__":
	print(my_test(10000))
	print(my_test(100000))
	print(my_test(1000000))
	
	