#### cbrt 函数的功能分解，把概念清晰的操作抽象为函数

def improve(x, guess):
    return (2.0 * guess + x / guess / guess) / 3
    
def accept(guess, tmp):
    return abs((tmp - guess)/guess) < 1E-6

def cbrt(x):
    if x == 0.0:
        return 0.0
    guess = x
    while True:
        tmp = improve(x, guess)
        if accept(guess, tmp):
            return tmp
        guess = tmp
