###### 通用方法1：等距检查，选择最接近解的值

###### 求立方根的函数 cbrt
def cbrt(x):
    x = float(x)  # 能转换也表示 x 是合理的参数
    sign = -1 if x < 0.0 else 1
    x = abs(x)
    test, root = 0.0, 0.0
    
    while test**3 <= x:
        if abs(test**3 - x) < abs(root**3 - x):
            root = test
        test += 0.001
        
    return sign * root

###### 测试 cbrt 的函数，用从 a 到 b 步长为 d 的一系列数做试验
def test_cbrt(a, b, d):
    z = a
    while z < b: # 由于 a/b/d 可能是浮点数，不能用 for
        r = cbrt(z)
        if fabs(r**3 - z) <= 0.001:
            print("Cube root of", z, "is", r)
        else:
            print("Cannot find cube root of", z, "| r**3:", r**3)
        z += d
    print("") # 空一行

###### 一些具体试验
##test_cbrt(0.0, 1.0, 0.1)
##test_cbrt(-1.0, 0.0, 0.2)
##test_cbrt(0.0, 200.0, 15.0)


