##### 一个简单的展示文本输入和拷贝的GUI程序

import tkinter as tk

import tkinter.messagebox as mb
import tkinter.filedialog as fd

class SimpleEditor(tk.Frame):
    def __init__(self):
        """A Simple Editor."""
        self.about = "This Editor\nis developed by\nqzy"
        tk.Frame.__init__(self)
        self.master.title("Simple Editor")
        self.grid()
        self.text = tk.Text(self, height=6, width=40)
        self.text.pack()
        top = self.winfo_toplevel()
        self.menubar = tk.Menu(top)
        top['menu'] = self.menubar
        filemenu = tk.Menu(self.menubar)
        filemenu.add_command(label="Save",
                   command=lambda: self.save(self.text))
        filemenu.add_command(label="Quit",
                   command=lambda: top.destroy())
        self.menubar.add_cascade(label="File", menu=filemenu)
        helpmenu = tk.Menu(self.menubar)
        helpmenu.add_command(label="About",
            command=lambda: mb.showinfo("About", self.about))
        self.menubar.add_cascade(label = 'Help', menu=helpmenu)

    def save(self, text):
        data = text.get("0.0", tk.END)
        filename = fd.asksaveasfilename(
                        filetypes=[("Text", "*.txt")],
                        title="Save as...")
        if filename:
            writer = open(filename, "w")
            writer.write(data)
            writer.close()
        else:
            mb.showwarning("Warning", "No filename is given")

SimpleEditor().mainloop()


    



