## 模块 pi_main.py 实现 Pi 估值程序的主线程，主要建立了一个 GUI 类，
## 还定义了一个计算 Pi 值的辅助函数，队列 rqueue 用于线程间交换信息。

import tkinter as tk

from queue import Queue, Empty
from random import randrange

from pi_monte import Pi_est

def pi_value(passed, total): # 基于试验结果计算 Pi 的估值
    return (6 / (passed / total))**0.5

rqueue = Queue()

class Pi_GUI(tk.Frame):
    def __init__(self, min_=10000, max_=20000):
        self._total = 0  # 累积的总试验次数
        self._passed = 0 # 累积的总通过次数
        self._min = min_ # 一次试验中模拟次数的下界
        self._max = max_ # 一次试验中模拟次数的上界

        tk.Frame.__init__(self)
        self.master.title("Monte Carlo Pi Estimater")
        self.grid()
        
        # 有关总试验次数的变量、标签和数值显示
        self._totalVar = tk.StringVar()
        self._totalVar.set("0")
        self._total_label = tk.Label(self, text="Total Tests:",
                                     anchor=tk.W, width=16)
        self._total_label.grid(row=0, column=0)
        self._total_num = tk.Label(self, anchor=tk.E, width=20,
                                   textvariable=self._totalVar)
        self._total_num.grid(row=0, column=1)

        # 有关通过的试验的变量、标签和数值显示
        self._passVar = tk.StringVar()
        self._passVar.set("0")
        self._pass_label = tk.Label(self, text="Passed Tests:",
                                    anchor=tk.W, width=16)
        self._pass_label.grid(row=1, column=0)
        self._pass_num = tk.Label(self, anchor=tk.E, width=20,
                                  textvariable=self._passVar)
        self._pass_num.grid(row=1, column=1)

        # 有关 Pi 估值的变量、标签和数值显示
        self._piVar = tk.StringVar()
        self._piVar.set("0.0")
        self._pi_label = tk.Label(self, text="Pi Estimated:",
                                  anchor=tk.W, width=16)
        self._pi_label.grid(row=2, column=0)
        self._pi_est = tk.Label(self, anchor=tk.E, width=20,
                                textvariable=self._piVar)
        self._pi_est.grid(row=2, column=1)
        
        # 启动一个测试线程的按钮
        self._compute = tk.Button(self, text="New\nTester",
                                 command=self._test, width=8)
        self._compute.grid(row=3, column=0, sticky=tk.W)
        
        # 连续启动三个测试线程的按钮
        self._compute3 = tk.Button(self, text="New 3\nTesters",
                                 command=self._test3, width=8)
        self._compute3.grid(row=3, column=0, columnspan=2)
        
        # 结束按钮
        self._finish = tk.Button(self, text="Finish", width=8,
                                 command=self.master.destroy)
        self._finish.grid(row=3, column=1, sticky=tk.E)

        self.mainloop() # 启动消息循环

    def _test(self): # 启动一个试验线程，并收集已经得到的结果
        """Launch a tester."""
        th = Pi_est(randrange(self._min, self._max), rqueue)
        th.start()
        self._collect()

    def _test3(self): # 连续启动三个试验线程，并收集已经得到的结果
        """Launch a tester."""
        for i in range(3):
            th = Pi_est(randrange(self._min, self._max), rqueue)
            th.start()
        self._collect()

    def _collect(self): # 收集结果的辅助函数
        no_data = True
        while True:
            try:
                p, t = rqueue.get(timeout=0.1)
            except Empty:
                if no_data: return
                else: break
            self._passed += p
            self._total += t
            no_data = False
        self._totalVar.set(str(self._total))
        self._passVar.set(str(self._passed))
        self._piVar.set("{:18.16f}".format(pi_value(self._passed, self._total)))            

Pi_GUI(20000, 50000)

