### 银行类的定义

import tkinter as tk
import tkinter.messagebox as mb
from input_win import InputWin

class UI(tk.Frame):
    gnotes = ("欢迎使用电话簿\n\n请选择需要的操作")
    info_title = "电话簿信息"
    
    def __init__(self, host):
        tk.Frame.__init__(self)
        self.master.title("电话簿管理器")
        self.grid()

        self._host = host

        self._upper = tk.Frame(self)
        self._upper.grid()
        self._lower = tk.Frame(self)
        self._lower.grid()

        # 做出界面上半部
        self._image = tk.PhotoImage(file="phonebook.png")
        title = tk.Label(self._upper, image=self._image)
        title.grid(row=0, column=0)
        note = tk.Label(self._upper, text=UI.gnotes, 
                        width=20, font=("Song", "16"))
        note.grid(row=0, column=1)

        # 做出界面下半部
        ops = (("添加联系人", self._add_entry),
               ("查找", self._search),
               ("保存电话簿", self._save),
               ("结束使用", self.master.destroy))
        i = 0
        for name, op in ops:
            but = tk.Button(self._lower, text=name, command=op)
            but.grid(row=0, column=i, padx=10, pady=4,
                     ipadx=4, ipady=2)
            i += 1

    def _add_entry(self):
        InputWin(title="添加联系人",
                 button_label="添加",
                 entries=("姓名", "电话号码"),
                 callback=self._set_entry).mainloop()

    def _set_entry(self, entry):
        if len(entry) != 2:
            return "输入格式错误"
        res = self._host.add(*entry)
        if not res:
            mb.showinfo(UI.info_title, "联系人已加入")
        return res

    def _search(self):
        InputWin(title="检索名字号码",
                 entries=("姓名", "电话号码"),
                 button_label="检索",
                 callback=self._lookup).mainloop()

    def _lookup(self, entry):
        if entry[0] == "": 
            if entry[1] == "":
                return "查询需提供名字或电话号码."
            else: # 给定电话号码，要求检索联系人名
                res = self._host.lookup_num(entry[1])
                if res: # 找到
                    mb.showinfo(UI.info_title, res)
                    return
                else:
                    return "没有这个电话号码."
        else:
            if entry[1] == "": # 给定人名检索电话号码
                res = self._host.lookup_name(entry[0])
                if res: # 找到
                    mb.showinfo(UI.info_title, res)
                    return
                else:
                    return "没有这个联系人."
        # 用户提供了联系人名和电话号码
        res = self._host.lookup_num(entry[0])
        if not res:
            return "没有这个联系人."
        return "联系人号码是 " + res[1]                    

    def _save(self):
        self._host.save()
        mb.showinfo(UI.info_title, "电话簿已保存.")

    def start(self, load_ok):
        if not load_ok:
            mb.showinfo(UI.info_title,
                        "无法装入指定文件\n\n用空电话簿.")
        self.mainloop()

if __name__ == "__main__":
    UI(None).start(1)


